#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_getHandle()
 *
 */
DSI_OBJECT* CP_getHandle(char* name)
{
  int NS_errno;
  DSI_OBJECT* dsi_obj;
  int ns_errno;
  NS_Communicator *comm;

  /************************************/
  /* Contacting the proxy		*/
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_GET_HANDLE) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  if(sendString(comm,name) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    dsi_obj = NULL;
    ns_errno = NetSolveProxyError;
    return dsi_obj;
  }
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    dsi_obj = NULL;
    ns_errno = NS_errno;
    return dsi_obj;
  }

  dsi_obj = (DSI_OBJECT *)malloc(sizeof(DSI_OBJECT));
  dsi_obj->dsi_file = (DSI_FILE *)malloc(sizeof(DSI_FILE));
  if(recvDsiObj(comm, dsi_obj) == -1)
  {
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return NULL;
  }

  endTransaction(comm);

  ns_errno = NetSolveOK;
  return dsi_obj;
}
