/*****************************************************************/
/*      CP_getallserver.c                                        */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_getallServers()
 *
 */
int CP_getAllServers(NS_ServerDesc ***list)
{
  NS_Communicator *comm;
  int nb_servers,i;
  int NS_errno;


  /************************************/
  /* Contacting the proxy             */
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_SERVER_LIST) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NS_errno;
    return -1;
  }

  if (recvInt(comm,&nb_servers) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  *list = (NS_ServerDesc **)calloc(nb_servers,sizeof(NS_ServerDesc*));
  for (i=0;i<nb_servers;i++)
  {
    (*list)[i] = recvServerDesc(comm);
    if ((*list)[i] == NULL)
    {
      endTransaction(comm);
      ns_errno = NetSolveProxyError;
      *list = NULL;
      return -1;
    }
  }
  endTransaction(comm);

  ns_errno = NetSolveOK;
  return nb_servers;
}
