/*****************************************************************/
/*      CP_getallproblems.c                                      */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"

#include "proxyjobdesc.h"
#include "proxy.h"

#ifndef WIN32
#include <unistd.h>
#endif /* UNIX */

#include <signal.h>
#include <time.h>


/*
 * CP_getallproblems()
 *
 */
int CP_getAllProblems(NS_ProblemDesc ***list)
{
  NS_Communicator *comm;
  int nb_problems,i;
  int NS_errno;


  /************************************/
  /* Contacting the proxy             */
  /************************************/

  comm = contactProxy(1);
  if (comm == NULL)
  {
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Sending */
  if (sendInt(comm,NS_PROT_PROBLEM_LIST) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }
  if (NS_errno != NetSolveOK)
  {
    endTransaction(comm);
    ns_errno = NS_errno;
    *list = NULL;
    return -1;
  }

  if (recvInt(comm,&nb_problems) == -1)
  {
    endTransaction(comm);
    *list = NULL;
    ns_errno = NetSolveProxyError;
    return -1;
  }

  *list = (NS_ProblemDesc **)calloc(nb_problems,sizeof(NS_ProblemDesc*));
  for (i=0;i<nb_problems;i++)
  {
    (*list)[i] = recvProblemDesc(comm);
    if ((*list)[i] == NULL)
    {
      endTransaction(comm);
      ns_errno = NetSolveProxyError;
      *list = NULL;
      return -1;
    }
  }
  endTransaction(comm);

  ns_errno = NetSolveOK;
  return nb_problems;
}
