/*****************************************************************/
/*      CP_awaitjobcompletion.c                                  */
/*      Jakob Oestergaard                                        */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "client.h"
#include "client2proxy.h"
#include "errno.h"

#include "proxyjobdesc.h"
#include "proxy.h"
#include <signal.h>
#include <time.h>

/*
 *  CP_awaitJobCompletion()
 *
 *  Blocks until the given rd either
 *  completes with success or fails
 */
int CP_awaitJobCompletion(NS_RequestDesc *rd)
{
  int error_code;
  NS_Communicator *comm;
  int NS_errno;

  /********************************************/
  /* contact the proxy 			      */
  /********************************************/
  comm = contactProxy(1);
  if (comm == NULL)
  {
    netsolvePerror("contactProxy()");
    ns_errno = NetSolveProxyError;
    return -1;
  } 

  /* Sending */
  if ((sendInt(comm,NS_PROT_AWAIT_COMPLETION) == -1)  ||
      (sendInt(comm,rd->request_id) == -1))
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }

  /* Receiving */
  if (recvInt(comm,&NS_errno) == -1)
  {
    fprintf(STDERR "recvInt returned -1: NS_errno = %i\n", NS_errno);
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  } 
  if (NS_errno != NetSolveOK)
  {
    fprintf(STDERR "recvInt returned successfully: NS_errno = %i\n", NS_errno);
    endTransaction(comm);
    ns_errno = NS_errno;
    return -1;
  }

  if (recvInt(comm,&error_code) == -1) /* The actual job status */
  {
    fprintf(STDERR "recvInt returned -1, error_code = %i\n", error_code);
    endTransaction(comm);
    ns_errno = NetSolveProxyError;
    return -1;
  }
  endTransaction(comm);

  ns_errno = error_code;
  if (ns_errno == NetSolveOK)
    return 1;
  return -1;
}
