/*****************************************************************/
/*      netslwt.c                                                */
/*      Version 1.0                      Henri Casanova          */
/*****************************************************************/

/*
 * fnetslwt() : FORTRAN interface 
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"


void fnetslwt(int *request_id,int *info)
{
  int status, i;
  int elapsed;
  NS_RequestDesc *rd = requests[*request_id];
 
  if (rd == NULL) {
    *info = NetSolveInvalidRequestID;
    return;
  }

  status = netsolveWaitRequest(rd->assignment, &rd, &elapsed);

  if (status != -1)
  {

    /* take output_ptrs of the strings in output */
    for (i=0; i<rd->pd->nb_output_objects; i++)
    {
      if (rd->pd->output_objects[i]->object_type != NETSOLVE_STRING)
        continue;
      strcpy(output_ptrs[*request_id][i],
           rd->pd->output_objects[i]->attributes.string_attributes.ptr);
      free(rd->pd->output_objects[i]->attributes.string_attributes.ptr);
    }

    /* take care of the strings in input */
    for (i=0; i<rd->pd->nb_input_objects;i++)
    {
      if(!isStringArgument(rd->pd,rd->pd->calling_sequence->arg_to_mnemonic[i]))
        continue;
      switch(rd->pd->input_objects[i]->object_type)
      {
        case NETSOLVE_STRING:
          free(rd->pd->input_objects[i]->attributes.string_attributes.ptr);
          break;
      }
    }
    ns_errno = NetSolveOK;
  }

  freeProblemDesc(rd->pd);
  free(output_ptrs[*request_id]);
  freeRequestDesc(rd);
  requests[*request_id] = NULL;
  output_ptrs[*request_id] = NULL;

  *info = ns_errno;
  return;
}
