/*****************************************************************/
/*      netslwt.c                                                */
/*      Version 1.0                      Henri Casanova          */
/*---------------------------------------------------------------*/
/*  netslwt()                                                    */
/*****************************************************************/

/*
 * netslwt() : vararg C Interface to the NetSolve Client
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"

int netslwt(int request_id)
{
  int status;
  int elapsed;
  NS_RequestDesc *rd = requests[request_id];
 
  if (rd == NULL)
    return NetSolveInvalidRequestID;

  status = netsolveWaitRequest(rd->assignment,
                               &(requests[request_id]), &elapsed);

  if (status != -1)
  {
    int i;

    /* take output_ptrs of the strings in output */
    for (i=0;i<requests[request_id]->pd->nb_output_objects;i++)
    {
      if (requests[request_id]->pd->output_objects[i]->object_type 
                != NETSOLVE_STRING)
        continue;
      strcpy(output_ptrs[request_id][i],
          requests[request_id]->pd->output_objects[i]->attributes.string_attributes.ptr);
      free(requests[request_id]->pd->output_objects[i]->attributes.string_attributes.ptr);
    }
    ns_errno = NetSolveOK;
  }

  freeProblemDesc(rd->pd);
  free(output_ptrs[request_id]);
  freeRequestDesc(rd);
  requests[request_id] = NULL;
  output_ptrs[request_id] = NULL;
  return ns_errno;
}
