/*****************************************************************/
/*      netslpr.c                                                */
/*      Henri Casanova          				 */
/*---------------------------------------------------------------*/
/*  netslpr()                                                    */
/*****************************************************************/

/*
 * netslpr() : vararg C Interface to the NetSolve Client
 */

#include <stdarg.h>
#include "core.h"
#include "client.h"
#include "callingsequence.h"
#include "cfortranclient.h"
#include "mnemonics.h"

int netslpr(int request_id)
{
  int status;
  NS_RequestDesc *rd = requests[request_id];
 
  if (rd == NULL)
    return NetSolveInvalidRequestID;

  status = netsolveProbeRequest(rd->assignment, &rd);

  if (ns_errno == NetSolveNotReady)
    return NetSolveNotReady;

  if (status == -1)
  {
    freeProblemDesc(rd->pd);
    free(output_ptrs[request_id]);
    freeRequestDesc(rd);
    requests[request_id] = NULL;
    output_ptrs[request_id] = NULL;
  }

  return ns_errno;
}
