/*****************************************************************/
/*      networkmeasurement.c                                     */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*****************************************************************/

#include "core.h"
#include "networkmeasurement.h"
#include <unistd.h>

/*
 * getNetworkMeasurement()
 *
 * asseses the Network bandwidth and latency.
 * start by sleeping a random amount of seconds.
 */
void getNetworkMeasurement(NS_HostDesc *source, int sourceport,
                            NS_HostDesc *dest, int destport)
{
  int sock;
  NS_Communicator *comm;
  int latency,bandwidth,time;

  sleep(rand()%20+10);
  sock = connectToSocket(source->hostname,source->IPaddr,sourceport);
  if (sock == -1)
  {
    netsolvePerror("connectToSocket()");
    exit(0);
  } 

  comm = initTransaction(sock,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("initTransaction()");
    close(sock);
    exit(0);
  } 
  if (sendInt(comm,NS_PROT_PONG_REQUEST) == -1)
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
  if (sendHostDesc(comm,dest) == -1)
  {
    netsolvePerror("sendHostDesc()");
    endTransaction(comm);
    exit(0);
  }
  if (sendInt(comm,destport) == -1)
  {  
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
 

  if (recvInt(comm,&latency) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    exit(0);
  }
  if (recvInt(comm,&bandwidth) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    exit(0);
  }
  if (recvInt(comm,&time) == -1)
  {
    netsolvePerror("recvInt()");
    endTransaction(comm);
    exit(0);
  }
  endTransaction(comm);
  
  sock = connectToSocket(dest->hostname,
                           dest->IPaddr,
                           destport);
  if (sock == -1)
  {
    netsolvePerror("connectToSocket()");
    exit(0);
  }

  comm = initTransaction(sock,DATA_XDR);
  if (comm == NULL)
  {
    netsolvePerror("initTransaction()");
    close(sock);
    exit(0);
  }
  if (sendInt(comm,NS_PROT_NETWORK_REPORT) == -1)
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
  if (sendIPaddr(comm,&(dest->IPaddr)) == -1)
  {
    netsolvePerror("sendIPaddr()");
    endTransaction(comm);
    exit(0);
  }
  if (sendIPaddr(comm,&(source->IPaddr)) == -1)
  {
    netsolvePerror("sendIPaddr()");
    endTransaction(comm);
    exit(0);
  }
  if (sendInt(comm,latency) == -1)
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
  if (sendInt(comm,bandwidth) == -1)
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
  if (sendInt(comm,time) == -1)
  {
    netsolvePerror("sendInt()");
    endTransaction(comm);
    exit(0);
  }
  endTransaction(comm);
  exit(0);
}
