/*****************************************************************/
/*      exchange_mappings.c                                      */
/*      Henri Casanova                                           */
/*---------------------------------------------------------------*/
/*  sendMappings()                                               */
/*****************************************************************/

#include <netdb.h>
#include "core.h"
#include "agentglobal.h"
#include "exchangemappings.h"

/*
 *  sendMappings()
 *
 *  Send the mappings to a communicator
 */
int sendMappings(NS_Communicator *comm)
{
  NS_LinkItem *link;
  int count = 0;
  NS_IPaddr_type IPaddr;
  char *nickname;
  NS_MappingDesc *t;
  NS_ServerDesc *sd;
  NS_ProblemDesc *pd;

  link = global.mappings->start;
  while(link != 0)
  {
    t = (NS_MappingDesc *)(link->content);
    sd = (NS_ServerDesc *)(t->server_desc);
    if ( sd->broadcast == 1)
      count++;
    link=link->next;
  }
  if (sendInt(comm,count) == -1)
  {
    netsolvePerror("sendInt()");
    return -1;
  }
  link = global.mappings->start;
  while(link != 0)
  {
    t = (NS_MappingDesc *)(link->content);
    sd = (NS_ServerDesc *)(t->server_desc);
    pd = (NS_ProblemDesc *)(t->problem_desc);
    IPaddr   = sd->host_desc->IPaddr;
    nickname = pd->nickname;
    
    if (sd->broadcast == 1)
    {
      if (sendIPaddr(comm,&IPaddr) == -1)
      {
        netsolvePerror("sendIPaddr()");
        return -1;
      }
      if (sendString(comm,nickname) == -1)
      {
        netsolvePerror("sendString()");
        return -1;
      }
    }
    link=link->next;
  }
  return 0; 
}

/*
 *
 *  recvMappings()
 *
 *  Receive the mappings from a communicator
 */
int recvMappings(NS_Communicator *comm)
{
  int i,nb_mappings;
  NS_IPaddr_type IPaddr;
  char *nickname;
  NS_ServerDesc **sd;
  NS_ProblemDesc **pd;
  NS_MappingDesc **md;
  NS_MappingDesc *new;

  if (recvInt(comm,&nb_mappings) == -1)
  {
    netsolvePerror("recvInt()");
    return -1;
  }
  for (i=0;i<nb_mappings;i++)
  {
    /* Receive the server IPaddr and problem nickname */
    if (recvIPaddr(comm,&IPaddr) == -1)
    {
      netsolvePerror("recvIPaddr()");
      return -1;
    }
    if (recvString(comm,&nickname) == -1)
    {
      netsolvePerror("recvString()");
      return -1;  
    }
    /* Lookup the server and the problem */
    sd = lookupServer(&IPaddr);
    pd = lookupProblem(nickname);
    free(nickname);

    if (*sd == NULL)   /* Server not found */
    {
#ifdef VIEW
      fprintf(stderr,"Warning: received a mapping for an unknown server\n");
#endif
      free(sd); free(pd);
      continue;
    }
    if (*pd == NULL)   /* Problem not found */
    {  
#ifdef VIEW
      fprintf(stderr,"Warning: received a mapping for an unknown problem\n");
#endif
      free(sd); free(pd);
      continue;
    }
    new = newMappingDesc(*pd,*sd);

    /* Is the mapping already known ? */
    md = lookupMappingAll(new);
    if (*md == NULL) /* new one */
      addMapping(new); 
    else  /* Already there */
      freeMappingDesc(new);

    free(pd); free(sd); free(md);
  }
  return 0;
}
