/*****************************************************************/
/*      agent_terminates.c                                       */
/*      Henri Casanova                                           */
/*      modified by Karine Heydeman                              */
/*      modified by Susan Blackford and Patrick Geoffray         */
/*---------------------------------------------------------------*/
/*  Abort()                                                      */
/*****************************************************************/

#include <signal.h>
#include "core.h"
#include "agentglobal.h"
#include "abort.h"

#ifdef NWS
#include "nws_api.h"
#include "nwsutils.h"
#endif

/*
 *  Abort()
 *
 *  Terminates the agent
 */
int Abort()
{
#ifdef HBM
  (void)kill(global.hbmdc_pid,SIGTERM);
  (void)kill(global.hbmproxy_pid,SIGTERM);
#endif
#ifdef NWS
  char what[1024];

  (void) AdminNWSFore(global.my_self->host_desc->hostname,what,"test");
  if (strncmp(what,"healthy",strlen("healthy")) ==0)
    processKillNWSHost(global.my_self->host_desc->hostname,NWS_DEFAULT_FORECASTER_PORT);
   if (strncmp(what,"dead",strlen("dead")) !=0)
     AdminNWSFore(global.my_self->host_desc->hostname,what,"kill");
  (void) AdminNWSMemory(global.my_self->host_desc->hostname,what,"test");
  if (strncmp(what,"healthy",strlen("healthy")) ==0)
    processKillNWSHost(global.my_self->host_desc->hostname,NWS_DEFAULT_MEMORY_PORT);
   if (strncmp(what,"dead",strlen("dead")) !=0)
     AdminNWSMemory(global.my_self->host_desc->hostname,what,"kill");
  (void) AdminNWSNameServer(global.my_self->host_desc->hostname,what,"test");
  if (strncmp(what,"healthy",strlen("healthy")) ==0)
    processKillNWSHost(global.my_self->host_desc->hostname,NWS_DEFAULT_NAMESERVER_PORT);
   if (strncmp(what,"dead",strlen("dead")) !=0)
     AdminNWSNameServer(global.my_self->host_desc->hostname,what,"kill");
#endif


  fprintf(stderr,"\nAgent Terminating\n");
  return 0;
}
