/*****************************************************************/
/*      socketutil.h                                             */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_SOCKETUTIL_H
#define __NS_SOCKETUTIL_H

#include "general.h"
#include "communicator.h"

/**
 **  FUNCTION PROTOTYPES
 **/

#ifndef WIN32
int establishSocket(int*,int);
#endif /* WIN32 */

NS_Socket_type connectToSocket(char*,NS_IPaddr_type,int);
int isThereSomethingOnTheSocket(NS_Socket_type);
NS_IPaddr_type getIPaddr(char*);

int closeSocket(NS_Socket_type);
int isSocketError(NS_Socket_type);

NS_Communicator *contactHost(char*,NS_IPaddr_type,int,int);

NS_Socket_type acceptConnection(NS_Socket_type listening_socket);
int bindToFirstAvailablePort(int,int*);

#endif

