/*****************************************************************/
/*      serverglobal.h                                           */
/*      Henri Casanova, Dorian Arnold                            */
/*****************************************************************/

#ifndef __NS_SERVERGLOBAL_H
#define __NS_SERVERGLOBAL_H


/**
 **  MACRO DEFINITIONS
 **/

/* First value for the port, +1 until it works */
#define PORT_INIT 9002

/* For the linked list */

#define addProblem(s) NSitemInsert(global.problems,s)
#define removeProblem(i) NSitemDelete(global.problems,(i),compProblemDescKey,freeProblemDesc)
#define lookupProblem(i) ((NS_ProblemDesc **)(NSitemLookup(global.problems,(i),compProblemDescKey)))

#define addAgent(s) NSitemInsert(global.agents,s)
#define removeAgent(i) NSitemDelete(global.agents,(i),compAgentDescKey,freeAgentDesc)
#define lookupAgent(i) ((NS_AgentDesc **)(NSitemLookup(global.agents,(i),compAgentDescKey)))


/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * ScaLAPACKGlobal
 *
 * These globals are to ensure that the necessary information is available
 * in all the various fork() and subroutine operations in the parallel version.
 */

typedef struct {
 int NUM_PROCS;
 int MYROW,MYCOL;
 int PROC_ROWS, PROC_COLS;
 int MYCONTXT;
 int ROW_BLOCK, COL_BLOCK;
 void *SIZE_PTR;
 FILE* globalfile;
} NS_ScaLAPACKGlobal;


/*
 * Global
 *
 * contains all the global variables 
 */

typedef struct {
  NS_ServerDesc *my_self;			/* The server's own descriptor */
  NS_LinkedList *problems;			/* The problem linked list     */
  NS_LinkedList *agents;     		/* The agent linked list       */
  NS_AgentDesc   *master;			/* The master descriptor       */
  char *scratch_path;			/* The scratch area            */
  char *Condor_path;			/* Possible Condor path        */
  int Condor_nb;			/* Possible # of Condor procs  */
  char *MPI_path;			/* Possible mpirun path        */
  int nb_MPInodes;			/* Possible Number of MPI nodes*/
  char* MPInodefile;			/* Possible MPI node file      */
  int workload_manager_pid;		/* PID of the workload manager */
#ifdef HBM
  int hbmlm_pid;    			/* PID of the HBM hbmlm        */
#endif
  char *netsolve_root_path;		/* $NETSOLVE_ROOT              */
  NS_Statistics *statistics;    		/* statistics 		       */
  NS_ScaLAPACKGlobal Scalapack_global;     /* globals for ScaLAPACK       */  
  int nb_problems;                      /* number of problems          */
  int sock;				/* Listening socket descriptor */
  char *log_file;      /* file for message logging */
  char *config_file;      /* file for message logging */
#ifdef KERBEROS5
  krb5_principal server;
  krb5_keytab keytab;
  krb5_context context;
  char *users_file;
  int require_auth;         /* true if authentication required */
#endif
}NS_Global;


/**
 **  GLOBAL VARIABLES
 **/

NS_Global global;

/**
 ** FUNCTION PROTOTYPES
 **/

int serverInit(int,char**);
int initMySelf();
int setCondor(char*);
int setScratchSpace(char*);
int setMPI(char*);
int setNumberProc(char*);
int setProblems(char*);
int problemInit(char**,int);
int registerToNetSolve();
int setMaster(char*);
int check_args(int, char **);
void print_usage(char *);
int set_defaults();
#ifdef KERBEROS5
int krb5_init();
#endif
void forkiterativeSolverService(NS_Socket_type,int,int,int,char*,char*,char*,
				int,int,char*,char*,NS_ProblemDesc*,
				NS_IPaddr_type,int);
int server_init(int argc,char **argv);


#endif

