/*****************************************************************/
/*      sequences.h                                              */
/*      Dieter Bachmann                                          */
/*****************************************************************/

#ifndef __NS_SEQUENCES_H
#define __NS_SEQUENCES_H


#define NS_NULL   &NS_EndArg


/* Data structures for sequence execution */



/* Global variables */
void*    NS_EndArg;              /* end of a vararg sequence */


/* FUNCTION PROTOTYPES */

/* user interface */
void    netsl_sequence_begin();     /* begin of bracket */ 
int     netsl_sequence_end(void*,...);       /* end of sequence, schedule jobs */

/* status functions */
int     netsl_sequence_status();    /* collecting calls? TRUE/FALSE */


/* Node-list manipulation */
NS_Node** netsl_get_Sequence();       /* get pointer to top/root Node */

/* Analyze dependencies */
int netsl_analyze_Graph(NS_Node*, NS_Node*);   /* analyze dependencies */
int get_output_id (void* tmp_ptr, NS_Node* top_node);

#endif

