/*****************************************************************/
/*      scheduler.h                                              */
/*      Henri Casanova                                           */
/*      modified by Karine Heydeman                              */
/*      modified by Susan Blackford and Patrick Geoffray         */
/*****************************************************************/

#ifndef __NS_SCHEDULER_H
#define __NS_SCHEDULER_H

/**
 **  MACRO DEFINITIONS
 **/
#define FAILURE_THRESHHOLD 2

/**
 ** STRUCTURE DEFINITIONS
 **/
typedef struct {
  NS_ServerDesc *d;
  int score;
  int sendtime;
  int forecast;
}NS_ScoredServerDesc;


/**
 **  FUNCTION PROTOTYPES
 **/

void assignServer(NS_ProblemDesc*,int,int,int,NS_ServerDesc***,int**,int*);
int computeScore(NS_ProblemDesc*,int,int,int,NS_ServerDesc*,NS_ScoredServerDesc *);
#ifdef sunos
int scoreCompare(void*,void*);
#else
int scoreCompare(const void*,const void*);
#endif
int computeCommunicationCost(int,int,NS_ServerDesc*);
int computeComputationCost(NS_ProblemDesc*,int,NS_ServerDesc*,int*);
double evalFlops(NS_ProblemDesc*,int);
#ifdef NWS
int extractNWSworkload(NS_ServerDesc* sd);
int Bestforecast(NWSAPI_ForecastCollection  *Forecast);
#endif




#endif
