/*****************************************************************/
/*      scalapackservice.h                                       */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_SCALAPACKSERVICE_H
#define __NS_SCALAPACKSERVICE_H


/**
 **  MACRO DEFINITIONS
 **/
#define DTYPE 0
#define CTXT_ 1
#define M_ 2
#define N_ 3
#define MB_ 4
#define NB_ 5
#define RSRC_ 6
#define CSRC_ 7
#define LLD_ 8


/**
 **  GLOBAL VARIABLES
 **/
int MYROW,MYCOL;
int PROC_ROWS, PROC_COLS;
int MYCONTXT;
int ROW_BLOCK, COL_BLOCK;
int NUM_PROCS;

FILE *globalfile;

/**
 **  FUNCTION PROTOTYPES
 **/
int solve(NS_ProblemDesc*,NS_Object**,NS_Object**);
void forkScaLAPACKService(NS_Socket_type,int,int,int,char*,char*,char*,int,int,
                         char*,char*,NS_ProblemDesc*,NS_IPaddr_type,int);
int sendOutputObjectFromFiles(NS_Communicator*,NS_ProblemDesc*);
void scalapack_exit(char*);
int ScaLAPACKReadInputObjectsFromFiles(NS_ProblemDesc*);
int ScaLAPACKWriteOutputObjectsToFile(int,NS_ProblemDesc*);
int *descInit(int,int,int);
int Cnumroc(int,int,int,int,int);
void Cpdtran(int,int,double,double*,int,int,int*,
                    double,double*,int,int,int*);
int read2DBlockCyclicMatrix(char*,NS_Object*);
int Cpdlaread(char *infile, double *data, int *desca);
int Cpdlawrite(char *outfile, double *data, int *desca);
int *makeIpiv(int size);
int HPC_numroc( const int N, const int NB, const int PROC,
                const int SRCPROC, const int NPROCS );
int ScaLAPACKWriteOutputObjectsToFiles(int client_major,
          NS_ProblemDesc *pd);
int write2DBlockCyclicMatrix(char *filename,NS_Object *obj);

int iterread(char *infile, double *data, int *desca);
int iterwrite(char *outfile, double *data, int *desca);

int iterReadInputObjectsFromFiles(NS_ProblemDesc *pd);
int initOutputObjects(NS_ProblemDesc *pd);
int iterWriteOutputObjectsToFiles(int client_major, NS_ProblemDesc *pd);

/**
 ** CONVERSION ROUTINES FOR C/FORTRAN FILE I/O COMPATIBILITY
 **/
int *makeIpiv(int);
#ifdef ADD_
int mywrite_int_(int*);
#endif
#ifdef F2C
int mywrite_int__(int*);
#endif
#ifdef UPCASE
int MYWRITE_INT(int*);
#endif
#ifdef NOCHANGE
int mywrite_int(int*);
#endif
#ifdef ADD_
int mywrite_double_(double*);
#endif
#ifdef F2C
int mywrite_double__(double*);
#endif
#ifdef UPCASE
int MYWRITE_DOUBLE(double*);
#endif
#ifdef NOCHANGE
int mywrite_double(double*);
#endif
#ifdef ADD_
int myread_int_(int*);
#endif
#ifdef F2C
int myread_int__(int*);
#endif
#ifdef UPCASE
int MYREAD_INT(int*);
#endif
#ifdef NOCHANGE
int myread_int(int*);
#endif

/* Function prototypes for C interface to the BLACS */

void Cblacs_pinfo(int *mypnum, int *rtn);

void Cblacs_get(int a, int b, int *MYCONTXT);

void Cblacs_gridinit(int *MYCONTXT, char *a, int PROC_ROWS, int PROC_COLS);

void Cblacs_gridinfo(int MYCONTXT, int *i, int *j, int *MYROW, int *MYCOL);

void Cblacs_gridexit(int MYCONTXT);

void Cblacs_exit(int a);

void Cigebs2d(int MYCONTXT, char *a, char *b, int c, int d, int *info, int e);

void Cigebr2d(int MYCONTXT, char *a, char *b, int c, int d, int *info, int e, int f, int g);

void Cdgerv2d(int, int,int,double *,int,int,int);

void Cdgesd2d(int,int,int,double *, int,int,int);

#endif

