/*****************************************************************/
/*      request.h                                                */
/*	Henri Casanova					         */
/*---------------------------------------------------------------*/

#ifndef __NS_REQUESTDESC_H
#define __NS_REQUESTDESC_H

/*****************************************************************/

/**
 **  MACRO DEFINITIONS
 **/


/**
 **  STRUCTURE DEFINITIONS
 **/

typedef struct{
  int request_id;

  /* data */
  NS_ProblemDesc *pd;
  NS_Object **input;
  NS_Object **output;

  int encoding;
  int assignment;  /*== whether request was assigned or submitted ==*/

  /* prediction and statistics */
  int predicted_time;
  int start_time;

  /* Place to download the output from */
  char *hostname;
  NS_IPaddr_type IPaddr;
  int port;

}NS_RequestDesc;

/**
 ** FUNCTION PROTOTYPES
 **/

NS_RequestDesc *newRequestDesc();
void freeRequestDesc(NS_RequestDesc*);

#endif

