/*****************************************************************/
/*      node.h                                                   */
/*	Dieter Bachmann					         */
/*---------------------------------------------------------------*/

#ifndef __NS_NODE_H
#define __NS_NODE_H

/*****************************************************************/




/* Defines */
#define NETSOLVE_NO_DEPENDENCY     0
#define NETSOLVE_INPUT_DEPENDENCY  1
#define NETSOLVE_OUTPUT_DEPENDENCY 2
#define NETSOLVE_LOCAL_DEPENDENCY  3

#define NETSOLVE_INPUT  1
#define NETSOLVE_OUTPUT 2

#define NETSOLVE_NULL 0

#define NS_UNDEFINED 0
#define NS_RUNNING 1
#define NS_WAITING 2
#define NS_TERMINATE 3
#define NS_DEPENDEND 4


#define NETSL_END(args)           netsl_sequence_end(args, &NS_EndArg)

/* Types for sequencing */


typedef struct NS_Node_   NS_Node;    
typedef struct NS_Dep_    NS_Dep;
typedef struct NS_Serverlist_    NS_Serverlist;



/* Structs for sequencing */


/* The node structure holds a problem description, data and control dependencies */
/* and execution information */
struct NS_Node_ {
    int            id;         /* problem id */     
    NS_ProblemDesc    *pd;        /* single Call pointer or not? */
    NS_Dep         *in_dep;    /* implicit dependency graph (input)  */
    NS_Dep         *out_dep;   /* implicit dependency graph (output) */
    NS_Node        *next;      /* linked list forward */
    NS_Node        *last;      /* linked list backwards */

    /* client */
    void           **tmp_output_ptr; /* for strings */

    /* proxy */
    NS_Serverlist  *servers;    /* attached list of servers for this problem used in the Proxy only */  
    int            input_size;
    int            output_size;
    int            problem_size; 
    /* server values */
    int            process_id;    /* process id of a running job */
    int            exec_status;   /* execution status of a job RUNNING / WAITING / DEPENDENT / TERMINATE */
                                  /* NS_UNDEFINED 0 */
                                  /* NS_RUNNING 1 */
                                  /* NS_WAITING 2 */
                                  /* NS_TERMINATE 3 */
                                  /* NS_DEPENDEND 4 */
};


/* dependency structure */
struct NS_Dep_ {
    int  size;            /* Number of arguments */
    /* arrays of size one dependency per psrameter 1:1 */
    int *dep_type;        /* type of dependency  */
                          /* NETSOLVE_NO_DEPENDENCY     0 */
                          /* NETSOLVE_INPUT_DEPENDENCY  1 */
                          /* NETSOLVE_OUTPUT_DEPENDENCY 2 */
                          /* NETSOLVE_LOCAL_DEPENDENCY  3 */

    int *dest_node;       /* Link destination call number */
    int *dest_arg;        /* Link destination argument number */


};



struct NS_Serverlist_ {
    int  nb_servers;            /* number of available servers */
    char **hostlist;            /* names of available servers */
    NS_IPaddr_type *IPaddrlist;    /* ipadresses */
    int *portlist;              /* server ports */
    int *dataformatlist;        /* data formats */
    int *predictedtimelist;     /* predicted time */
};




int      netsl_insert_Node(NS_Node*,NS_Node**); /* insert new node */
int      netsl_delete_Nodes(NS_Node*);       /* delete all nodes */
NS_Node* netsl_new_Node();           /* geneate new node */
NS_Node* netsl_new_Node_Dep(NS_ProblemDesc*, int, int);           /* geneate new node */
int      netsl_send_Nodes (NS_Communicator *comm, NS_Node *top_node);
NS_Node* netsl_recv_Node (NS_Communicator *comm);
int      netsl_get_nb_Nodes (NS_Node*);

int netsl_assign_file_names (NS_Node *top_node);
int recvInputObjectsToFiles_sequence(NS_Communicator *comm,NS_ProblemDesc *pd, int node_nr);
int netsl_may_run(NS_Node *top_node);
int netsl_fork_exec_all(NS_Node *top_node, int listening_socket, int ID, 
			int client_major, char* agent_name, int restriction_index,
			char* tmpdir, int proxy_IPaddr, int proxy_port);
int netsl_resolve_dependencies(NS_Node *top_node, int  wait_pid);
int netsl_exit_sequence_scheduler(NS_Node *top_node, int lifelink_pid, char *wd, NS_IPaddr_type proxy_IPaddr, 
				  int proxy_port, int elapsed, int solved, int client_major, 
				  int restriction_index, int ID, int listening_socket);
void processProblemSolve_sequence(NS_Communicator *comm);
void generateServiceProcess_sequence(NS_Communicator *comm, int restriction_index,
				     NS_Node *top_node,char *agent_name,
				     NS_IPaddr_type proxy_IPaddr, int proxy_port);

#endif

