/*****************************************************************/
/*      netsolvejobdesc.h                                        */
/*	Henri Casanova					         */
/*---------------------------------------------------------------*/

#ifndef __NS_NETSOLVEJOBDESC_H
#define __NS_NETSOLVEJOBDESC_H

/*****************************************************************/

/**
 **  MACRO DEFINITIONS
 **/

/**
 **  STRUCTURE DEFINITIONS
 **/

typedef struct{
  int error_code;        /* NetSolve error code          */
  NS_IPaddr_type IPaddr;    /* IPaddr of the server         */
  int port;              /* port of the server daemon    */
  int pid;               /* Pid of the server process    */
}NS_JobDesc;

/**
 ** FUNCTION PROTOTYPES
 **/

NS_JobDesc *newJobDesc();
void freeJobDesc(NS_JobDesc*);
int sendJobDesc(NS_Communicator*,NS_JobDesc*);
NS_JobDesc *recvJobDesc(NS_Communicator*);

#endif

