
/*
 * MCellComputationDesc structure
 */

#ifndef __NS_MCELLDRIVER_H
#define __NS_MCELLDRIVER_H


typedef struct {
char *mdlfile;    	/* path to the MDL file 		*/
int seed;		/* Random Number Generator Seed index	*/
int iterations;		/* Max number of iterations		*/
int nb_includefiles;    /* Number of included files             */
char **includefiles;    /* List of included files 		*/
int nb_outputfiles;     /* Number of output files               */
char **outputfiles;	/* List of output files			*/
} NS_MCellComputationDesc;

NS_MCellComputationDesc *constructMCellComputationDesc(char*,int,int);
void displayMCellComputationDesc(NS_MCellComputationDesc*);
void freeMCellComputationDesc(NS_MCellComputationDesc*);
NS_MCellComputationDesc **parseScriptFile(char*,int*);
int getNumberComps(char*);
int getRange(char*,int*,int*);
int fillInNetSolveData(int,NS_MCellComputationDesc**,char*,char***,char***,
           int*,char***,int*,int**,int**,char**,char**,char**);
void freeNetSolveData(int,char***,char***,
           int*,char***,int*,int**,int**,char**,char**,char**);
int isOriginalScript(char*);
void saveParseFile(char*,int,NS_MCellComputationDesc**);
NS_MCellComputationDesc **loadParseFile(char*,int*);

#endif

