/*****************************************************************/
/*      matlabclient.h                                           */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_MATLABCLIENT_H
#define __NS_MATLABCLIENT_H

#include "netsolvejobdesc.h"

/**
 ** MACRO DEFINITIONS
 **/
#define SEND_CMD   0
#define WAIT_CMD   1
#define PROBE_CMD  2
#define STATUS_CMD 3
#define ERROR_CMD  4

#define NB_MAX_REQUESTS 100

/**
 ** GLOBAL VARIABLES
 **/

NS_RequestDesc*requests[NB_MAX_REQUESTS];
int *input_allocateds[NB_MAX_REQUESTS];
int proxy_pid;

/**
 **  FUNCTION PROTOTYPES
 **/
int mxBlockingSolve(NS_ProblemDesc*);
void displayListOfProblems();
void mxDisplayListOfServersAgents();
void mxDisplayObject(NS_Object*);
void mxDisplayProblemDesc(char*);
int mxFillInOutputObjects(NS_ProblemDesc*,int,mxArray**);
void mxMatlabMerge(mxArray**,mxArray*);
int mxInitializeInputObjects(NS_ProblemDesc*,int,mxArray**,int**);
int mxInitializeOutputObjects(NS_ProblemDesc*);
void mexFunction(int,mxArray*[],int,const mxArray *[]);
int mxParseNbCommand(char*);
void mxSendRequest(int,mxArray*[],int,mxArray **);
void mxProbeRequest(int,mxArray*[],int,mxArray **);
void mxWaitRequest(int,mxArray*[],int,mxArray **);
void mxDisplayRequestStatus();
void mxDisplayRequest(NS_RequestDesc*);
int mxSubmitNonBlockingRequest(NS_RequestDesc*);
void mxSetProxyPort(int);
int mxGetProcxyPort();


/* Persistent Memory */
void mxMakeRequestDescPersistent(NS_RequestDesc*,int*);
void mexMakeProblemDescPersistent(NS_ProblemDesc*,int*);
void mexMakeCallingSequencePersistent(NS_CallingSequence*);
void mexMakeObjectPersistent(NS_Object*,int);

#endif

