/*****************************************************************/
/*      host.h                                                   */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_HOSTDESC_H
#define __NS_HOSTDESC_H


/**
 ** MACRO DEFINITIONS
 **/
#define HOST_UP 1
#define HOST_DOWN -1

/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * HostDesc
 *
 *  Contains all the information on a host running a server
 *  or an agent
 */

typedef struct {
  char *hostname;   		/* host name          */
  NS_IPaddr_type IPaddr;          /* IP addr            */
  int data_format;              /* Data Format        */
  int speed;                    /* Speed              */
  int host_status;              /* Up/Down            */
  int number_proc;              /* Number of procs    */
} NS_HostDesc;

/**
 **  FUNCTION PROTOTYPES
 **/

void freeHostDesc(NS_HostDesc*);
NS_HostDesc *newHostDesc();
int sendHostDesc(NS_Communicator*,NS_HostDesc*);
NS_HostDesc *recvHostDesc(NS_Communicator*);

#endif

