/*****************************************************************/
/*      historydesc.h                                            */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_HISTORYDESC_H
#define __NS_HISTORYDESC_H


/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * WorkloadHistory
 *
 *  Contains the workload history of the server
 */
typedef struct {
  int w;
  int time;
} NS_WorkloadHistory;

/*
 * NetworkHistory
 *
 *  Contains the network history of the server
 */
typedef struct {
  int latency;     /* in usec      */
  int bandwidth;   /* in bytes/sec */
  int time;
} NS_NetworkHistory;

/**
 **  FUNCTION PROTOTYPES
 **/
void freeNetworkHistory(NS_NetworkHistory*);
void freeWorkloadHistory(NS_WorkloadHistory*);
NS_NetworkHistory *newNetworkHistory();
NS_WorkloadHistory *newWorkloadHistory();
int sendNetworkHistory(NS_Communicator*,NS_NetworkHistory*);
NS_NetworkHistory *recvNetworkHistory(NS_Communicator*);
int sendWorkloadHistory(NS_Communicator*,NS_WorkloadHistory*);
NS_WorkloadHistory *recvWorkloadHistory(NS_Communicator*);
void addToWorkloadHistory(NS_WorkloadHistory*,int,int);
void addToNetworkHistory(NS_NetworkHistory*,int,int,int);

#endif

