/*****************************************************************/
/*      general.h                                                */
/*      Henri Casanova, Dorian Arnold                            */
/*****************************************************************/

#ifndef __NS_GENERAL_H
#define __NS_GENERAL_H

#include <time.h>
#include <string.h>
#include <stdlib.h>

/**
 ** GLOBAL VARIABLES
 **/
int ns_errno;  /* errno for internal use */

/**
 **  MACRO DEFINITIONS
 **/

#ifdef MATLAB
#define STDERR     
#define STDOUT
#define calloc mxCalloc
#define free mxFree
#define strdup mxStrdup
#define fprintf mexPrintf
char *mxStrdup(char*);
#else
#define STDERR stderr,
#define STDOUT stdout,

static char *NS_strdup(const char *sp)
{
   char *cp;

   cp = malloc( (strlen(sp)+1)*sizeof(char) );
   if (cp) strcpy(cp, sp);
   return(cp);
}

#ifdef strdup
   #undef strdup
#endif
#define strdup NS_strdup
#endif  /* MATLAB */

char ns_filenameptr[256], *ns_tempptr;
#define ns_printinfo() \
{ \
  strcpy(ns_filenameptr, __FILE__); \
  ns_tempptr = ns_filenameptr + strlen(ns_filenameptr)-1; \
  while(ns_tempptr[0] != '/' && ns_tempptr != ns_filenameptr){ \
    ns_tempptr--; \
  } \
  ns_tempptr++; \
  fprintf(stderr, "NS:%s:%d: ", ns_tempptr, __LINE__);\
}

#define netsolvePerror(x) \
{ \
  ns_printinfo(); \
  fprintf(stderr, "%s: %s\n", x, netsolveErrorMessage(ns_errno)); \
}

#ifdef DEBUG
#ifndef VIEW
#define VIEW 1
#endif
#endif

#ifdef WIN32
#define sleep(a) Sleep((a)*1000)
#endif /* WIN32 */

#ifdef WIN32
#define NS_Socket_type NS_SOCKET
#else
#define NS_Socket_type int
#endif


#ifndef MIN
#define MIN(a,b) (a)<(b) ? (a):(b)
#endif

#ifndef MAX
#define MAX(a,b) (a)>(b) ? (a):(b)
#endif

#define CONNECT_TIMEOUT 120
#define TRANS_TIMEOUT 240
#define MAX_CONNECTIONS 20
#define NB_MAX_JOBS 128

#define JOB_PENDING 0
#define JOB_DONE    1
#define JOB_FAILED  2

#define AGENT_PORT 9050
#define AGENT_LOGFILE "nsagent.log"
#define SERVER_LOGFILE "nsserver.log"

#define HBM_PROXY_PORT 9001
#define PORT_INIT 9002

#ifdef SYSVBFUNC

#include <memory.h>
#define BZERO(d,n)      memset(d,0,n)
#define BCMP(s,d,n)     memcmp(d,s,n)
#define BCOPY(s,d,n)    memcpy(d,s,n)
 
#else /* SYSVBFUNC */
 
#define BZERO(d,n)      bzero(d,n)
#define BCMP(s,d,n)     bcmp(s,d,n)
#define BCOPY(s,d,n)    bcopy(s,d,n)
 
#endif

#ifdef PLAT_T3E
#define NS_IPaddr_type unsigned short
#else
#define NS_IPaddr_type unsigned int
#endif

#define BYTE(x,y) (((unsigned char *)x)[(y)]&0xff)

#ifndef TRUE
#define TRUE 1
#endif

#ifndef FALSE
#define FALSE 0
#endif

/* TIMEOUT STUFF */
#define SET_TIMEOUT(x)                                     \
  if(alarm(x) != 0)                          \
/* #ifdef DEBUG                                               \
    fprintf(stderr, "Warning: previous alarm set\n");      \
#endif */

#define UNSET_TIMEOUT() alarm(0);

#define CHECK_TIMEOUT(x)           \
if (x == -1) {                     \
  if(errno == EINTR){              \
    errno = ETIMEDOUT;             \
    ns_errno = NetSolveTimedOut;   \
    return -1;                     \
  }                                \
}

/**
 ** FUNCTION PROTOTYPES
 **/
int getArch();
char *getNetSolveArch();
char *getNetSolveRoot();
char *getNetSolveAgent();
char *getUserName();
char *getHostName();
char *Ctime(time_t *);

#endif
