/*****************************************************************/
/*      farming.h                                                */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_FARMING_H
#define __NS_FARMING_H

#include "netsolveclient.h"

/**
 ** MACRO DEFINITIONS
 **/

#define MIN_WINDOW_SIZE 5

#define INT_ITERATOR 0
#define INT_ARRAY_ITERATOR 1
#define PTR_ARRAY_ITERATOR 2

/**
 **  STRUCTURE DEFINITIONS
 **/

/**
 **  FUNCTION PROTOTYPES
 **/

int *netsl_farmX(int,int,NS_ProblemDesc*,NS_Iterator**);
int constructIteratorArray(va_list,NS_ProblemDesc*,NS_Iterator***,int);
int generateArrayFromIterators(NS_ProblemDesc*,NS_VoidStarOrInt**,NS_Iterator**);

/* iterators */
NS_Iterator *ns_int(char*);
NS_Iterator *ns_int_array(int*,char*);
NS_Iterator *ns_ptr_array(void**,char*);
NS_VoidStarOrInt getNext(NS_Iterator*);
NS_VoidStarOrInt getValue(NS_SpecificIterator*,int);
int evalInteger(char*,int);
void freeIterator(NS_Iterator*);
void freeSpecificIterator(NS_SpecificIterator*);
int sendFarmedRequest(int,NS_ProblemDesc*,NS_Object***,NS_Object***,
         NS_Iterator**,void***,NS_RequestDesc **);
int pollFarmedRequest(int,NS_ProblemDesc*,NS_RequestDesc**,NS_Object***,int*,void***);
int reverseIterators(NS_ProblemDesc *pd, NS_Iterator **iterator_array);


#endif

