/*****************************************************************/
/*      codegenerator.h                                          */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_CODEGENERATOR_H
#define __NS_CODEGENERATOR_H


/**
 ** MACRO DEFINITIONS
 **/

#define DEF_FILE "fortran.h"
#define DEF_HEADER "def_header"
#define HEADER "header"
#define PHEADER "pheader"
#define TARGET "numerical"
#define TARGETMAKEFILE "Makefile.numerical"
#define MAKEFILE_NUM_LIB "Makefile.num_libs"
#define TARGETINITCODE "problem_init.c"
#define MNEMONIC_LENGTH 5  /* For instance 'mI212' */

#define MAX_LINE_LENGTH 456

/**
 ** STRUCTURE DEFINITIONS
 **/
typedef struct {
  int nb_funcs;
  char **funcs;
  int nb_libs;
  char **libs;
  int nb_dashis;
  char **dashis;
  int nb_includes;
  char **includes;
  int language;
}NS_ProblemDescAddendum;

typedef struct {
  int nb_pbs;
  NS_ProblemDesc **pds;
  NS_ProblemDescAddendum **pdadds;
  char *customized;
  int nb_libs;
  char **libs;
  int nb_dashis;
  char **dashis;
  int nb_includes;
  char **includes;
}NS_DescFileAttributes;

/**
 ** GLOBAL VARIABLES
 **/ 

FILE *targetfile;
FILE *initcodefile;
int linecount;
char line[MAX_LINE_LENGTH];
int is_condor_server;

#define C_NAME  "C"
#define F_NAME  "FORTRAN"
#define C       0
#define F       1

char *root;

/**
 ** FUNCTION PROTOTYPES
 **/
int generateMakefile(int,char**,char**,NS_DescFileAttributes**);
int processCode(FILE*,NS_ProblemDesc*);
int processLine(char*,char*,NS_ProblemDesc*);
char *processMnemonic(int,char*,int*,NS_ProblemDesc*);
int checkMnemonicList(char**,NS_ProblemDesc*);
int lookup(char**,char*);
int checkMnemonic(char*,NS_ProblemDesc*);
int checkExpression(char*,char**,int,NS_ProblemDesc*);
int write_line(char*);
int putTargetHeader();
int putHeaderDef(FILE*);
char *read_line(FILE*);
char *cleaned(char*);
int isCondorServer(char*);
int getDescFileNames(char*,char**);
void putInitCodeFileHeader(FILE*);
int processAllProblems(NS_DescFileAttributes**,char*,char*);
int reduceAttributes(NS_DescFileAttributes*);
int processProblem(NS_ProblemDesc**,NS_ProblemDescAddendum**,char*,char*);
int splitFile(char **,char*);
int createDefFile(NS_DescFileAttributes**,int);
int parsePROBLEM(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseFUNCTION(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseINCLUDE(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseDASHI(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseLIB(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseLANGUAGE(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseMAJOR(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parsePATH(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseDESCRIPTION(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseINPUT(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseOUTPUT(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseMATLAB_MERGE(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseCUSTOMIZED(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseCOMPLEXITY(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseCALLINGSEQUENCE(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int parseCODE(NS_ProblemDesc*,NS_ProblemDescAddendum*,char*);
int addIncludes(char*,NS_DescFileAttributes*);
int noFTPRequired(NS_DescFileAttributes*);
char *getFTPHost(char*);
char *getFTPFile(char*);
char *getFTPPath(char*);

NS_Object *parseObject(NS_ProblemDesc*,char*,char,int);
int parseCallingSequence(FILE*,NS_ProblemDesc*);

#endif

