/*****************************************************************/
/*      client.h                                                 */
/*      Henri Casanova                                           */
/*****************************************************************/

#ifndef __NS_CLIENT_H
#define __NS_CLIENT_H

#include "core.h"

/**
 ** MACRO DEFINITIONS
 **/

#define WAIT 0
#define PROBE 1

#define NS_NOASSIGNMENT 0
#define NS_ASSIGNMENT 1

#define NS_NOBLOCK 0
#define NS_BLOCK 1

/**
 **  GLOBAL VARIABLES
 **/

extern int my_major;
extern int my_data_format;
extern int proxy_port;

/**
 **  FUNCTION PROTOTYPES
 **/

/* Low level */
int determineSizes(NS_ProblemDesc*,NS_Object**,NS_Object**,int*,int*,int*);
int getAllProblems(NS_ProblemDesc***);
int getAllServers(NS_ServerDesc***);
int getAllAgents(NS_AgentDesc***);
int getNumberOfServers();

/* High level */
int netslinit(char *agent);
void reportFailure(NS_IPaddr_type,char*,int,int);
int netsolveInfo(char*,NS_ProblemDesc**);
int killRequest(NS_RequestDesc*);
int submit_problem(int, int, char*, NS_ProblemDesc*,NS_Object**,NS_Object**,int*, int);
NS_RequestDesc *netsolveSendRequest(int, char*, NS_ProblemDesc*, NS_Object**,NS_Object**);
int netsolveWaitRequest(int,NS_RequestDesc **, int *);
int netsolveWaitAssignment(NS_RequestDesc **, int *);
int netsolveProbeRequest(int, NS_RequestDesc **);
int netsolveProbeAssignment(NS_RequestDesc **);
int netsolveKillJob(NS_RequestDesc*);
void reportJobCompleted(NS_IPaddr_type);
int storeHandle(DSI_OBJECT*);
DSI_OBJECT* getHandle(char*);

/* Major */
int setMajor(char*);
int setMajorDefault(char*);

/* HBM */
int getStatusFromHBM(NS_RequestDesc*);



/* sequencing */
int netsolve_sequence_Blocking(NS_Node *top_node, int *elapsed);
NS_RequestDesc *netsolve_sequence_SendRequest(NS_Node *top_node);
int netsolveWaitRequest_sequence(NS_Node*, NS_RequestDesc **, int *);



#endif

