/*****************************************************************/
/*      agentglobal.h                                            */
/*      Henri Casanova, Dorian Arnold                            */
/*****************************************************************/

#ifndef __NS_AGENTGLOBAL_H
#define __NS_AGENTGLOBAL_H


/**
 **  MACRO DEFINITIONS
 **/

#define WAKE_UP 900  /* The agent Wakes up every WAKE_UP seconds and checks      */
                     /* if new network measurements are needed                   */

#define TTL     1800 /* the agent gathers network measurements every TTL seconds */
 

/* For the linked list */

#define addProblem(i) NSitemInsert(global.problems,i)
#define removeProblem(i) NSitemDelete(global.problems,(i),compProblemDescKey,freeProblemDesc)
#define lookupProblem(i) ((NS_ProblemDesc **)(NSitemLookup(global.problems,(i),compProblemDescKey)))

#define addHandle(i) NSitemInsert(global.handles,i)
#define removeHandle(i) NSitemDelete(global.handles,(i),compHandleName,freeHandle)
#define lookupHandle(i) ((DSI_OBJECT **)(NSitemLookup(global.handles,(i),compHandleName)))

#define addAgent(i) NSitemInsert(global.agents,i)
#define removeAgent(i) NSitemDelete(global.agents,(i),compAgentDescKey,freeAgentDesc)
#define lookupAgent(i) ((NS_AgentDesc **)(NSitemLookup(global.agents,(i),compAgentDescKey)))

#define addServer(i) NSitemInsert(global.servers,i)
#define removeServer(i) NSitemDelete(global.servers,(i),compServerDescKey,freeServerDesc)
#define lookupServer(i) ((NS_ServerDesc **)(NSitemLookup(global.servers,(i),compServerDescKey)))

#define addMapping(i) NSitemInsert(global.mappings,i)
#define removeMappingServer(i) NSitemDelete(global.mappings,(i),compMappingDescServerKey,freeMappingDesc)
#define lookupMappingServer(i) ((NS_MappingDesc **)(NSitemLookup(global.mappings,(i),compMappingDescServerKey)))
#define removeMappingProblem(i) NSitemDelete(global.mappings,(i),compMappingDescProblemKey,freeMappingDesc)
#define lookupMappingProblem(i) ((NS_MappingDesc **)(NSitemLookup(global.mappings,(i),compMappingDescProblemKey)))
#define removeMappingAll(i) NSitemDelete(global.mappings,(i),compMappingDescAllKey,freeMappingDesc)
#define lookupMappingAll(i) ((NS_MappingDesc **)(NSitemLookup(global.mappings,(i),compMappingDescAllKey)))


/**
 **  STRUCTURE DEFINITIONS
 **/

/*
 * Global
 *
 * contains all the global variables 
 */

typedef struct {
  NS_AgentDesc *my_self;			/* The server's own descriptor 	*/
  NS_LinkedList *problems;			/* The problem linked list     	*/
  NS_LinkedList *servers;     		/* The server linked list      	*/
  NS_LinkedList *agents;     		/* The agent linked list       	*/
  NS_LinkedList *mappings;                 /* The problem/server mappings 	*/
  NS_AgentDesc   *master;			/* The master descriptor       	*/
  NS_LinkedList *handles;		  /* Handles to DSI objects    */
#ifdef HBM
  int hbmdc_pid;                        /* PID of the HBM hbmdc        */
  int hbmproxy_pid;                     /* PID of the HBM proxy        */
#endif
  char *netsolve_root_path; 		/* $(NETSOLVE_ROOT)      	*/
  NS_Statistics *statistics;    		/* statistics 		       	*/
  int sock;				/* Listening socket descriptor 	*/
  char *log_file;        /* logs agent interactions */
}NS_Global;


/**
 **  GLOBAL VARIABLES
 **/

NS_Global global;

/**
 ** FUNCTION PROTOTYPES
 **/
extern int set_defaults(void);
extern int check_args(int argc, char **argv);
extern int daemon_init();

#endif

