%
% x: vector of X coordinates
% y: vector of Y coordinates
% threshhold: Limit for the Mandelbrot iterations
% blocksize: bloxk size (along X)
% max_requests: number of concurrent requests
%

function NSmandelbrot(xa,dx,xb,ya,dy,yb,threshold,nb_block,max_requests)

global guiwin;
global mandelwin;

figure(mandelwin);
colormap jet(256);
delete(gca);
h = axes('XLim',[xa xb],'YLim',[ya yb],...
'position',[0.05 0.05 0.9 0.9],'visible','off');
%axis('equal');
set(h,'CLim',[0 threshold],'CLimMode','manual');

requests = zeros(nb_block,nb_block);

startx = zeros(1,nb_block);
stopx = zeros(1,nb_block);
starty = zeros(1,nb_block);
stopy = zeros(1,nb_block);

xstep = ceil(ceil((xb-xa)/dx)/nb_block);
ystep = ceil(ceil((yb-ya)/dy)/nb_block);
for i=1:nb_block
  startx(i) = xa + (i-1)*xstep*dx;
  stopx(i) = min([startx(i)+xstep*dx xb]);
  starty(i) = ya + (i-1)*ystep*dy;
  stopy(i) = min([starty(i)+ystep*dy+dy yb]);
end

requests = zeros(2,max_requests);
nblocks = nb_block^2;
block_sequence = randperm(nblocks);
req_issued = 0;

for i = 1:min(max_requests,nblocks)
	req_issued = req_issued + 1;
	requests(1,i) = block_sequence(req_issued);
        a = ceil(requests(1,i)/nb_block);
	b = mod(requests(1,i),nb_block);
	if b == 0 
		b = nb_block;
	end
	requests(2,i) =  netsolve_nb('send','mandelbrot',threshold,startx(a),dx,stopx(a),starty(b),dy,stopy(b));
	if (requests(2,i) < 0)
		m = netsolve_errmsg(netsolve_err);
		return;
	end
end

while (1==1)
  finished = 1;
  for i=1:max_requests
      if (requests(1,i) ~= 0)
        e = netsolve_nb('probe',requests(2,i));
        if (e < -1)
          m = netsolve_errmsg(e);
          return;
        end
        if (e == 0)
          r = netsolve_nb('wait',requests(2,i));
	  a = ceil(requests(1,i)/nb_block);
	  b = mod(requests(1,i),nb_block);
	  if b == 0
		b = nb_block;
	  end
          subx = (startx(a):dx:stopx(a))';
          suby = (starty(b):dy:stopy(b))';
%	  z = zeros(size(suby,1),size(subx,1));
%	  z = r.*(62/threshold);
          surface(subx,suby,r(1:size(suby,1),1:size(subx,1)),'Parent',h);
          shading flat;
          drawnow
	  refresh;
          requests(1,i) = 0;
	  if req_issued < nblocks
		req_issued = req_issued + 1;
		requests(1,i) = block_sequence(req_issued);
		a = ceil(requests(1,i)/nb_block);
		b = mod(requests(1,i),nb_block);
		if b == 0
			b = nb_block;
		end
		requests(2,i) = netsolve_nb('send','mandelbrot',threshold,startx(a),dx,stopx(a),starty(b),dy,stopy(b));
        	if (requests(2,i) < 0)
                	m = netsolve_errmsg(netsolve_err);
                	return;
        	end
	  end
        end
      end
    end

  for i=1:max_requests
      if (requests(1,i) ~= 0)
        finished = 0;
      end
  end

  if (finished == 1)
    break;
  end
  pause(1)
end

figure(guiwin);

return;

