      IMPLICIT NONE

C
C  Max values - most important is MAX_BUFF_SIZE.  This times the
C  MPITEST_BUFF_EXTENT foptions.h must be GREATER than the largest message
C  size defined in mpitest_cfgf.h
C
C  Recommend setting it slightly larger than the max message size, to
C  avoid problems if a receive overflows the block (it will be detected).
C
      INTEGER MAX_RANKS
      INTEGER IOSIZE
      INTEGER MAX_BUFF_SIZE
      INTEGER MPITEST_FILENAME_MAX

      PARAMETER(IOSIZE=200)
      PARAMETER(MAX_RANKS=64)
      PARAMETER(MAX_BUFF_SIZE=4096)
      PARAMETER(MPITEST_FILENAME_MAX=256)

C
C  Remaining values are not typically modified by the user.
C  Changing magic numbers is dangerous.
C
C  Definitions for error messages
      INTEGER MPITEST_FATAL, MPITEST_NONFATAL, MPITEST_INFO0,
     &   MPITEST_INFO1, MPITEST_INFO2, MPITEST_VERIFY 

      PARAMETER(MPITEST_FATAL = -1, MPITEST_NONFATAL = -2)
      PARAMETER(MPITEST_INFO0 = -3, MPITEST_INFO1 = -4)
      PARAMETER(MPITEST_INFO2 = -5, MPITEST_VERIFY = -6)

C  These defines are indices into the MPITEST_mpi_datatypes[] array defined
C  in mpitest_user.h.  Append entries here and initialize in mpitest_user.h,
C  but do not modify these or you may cause unnecessary failures.
      INTEGER MPITEST_INTEGER
      INTEGER MPITEST_REAL
      INTEGER MPITEST_DOUBLE_PRECISION
      INTEGER MPITEST_COMPLEX
      INTEGER MPITEST_LOGICAL
      INTEGER MPITEST_CHARACTER

      INTEGER MPITEST_DOUBLE_COMPLEX
      INTEGER MPITEST_REAL2
      INTEGER MPITEST_REAL4
      INTEGER MPITEST_REAL8
      INTEGER MPITEST_INTEGER1
      INTEGER MPITEST_INTEGER2
      INTEGER MPITEST_INTEGER4
      INTEGER MPITEST_DATATYPE_MAX


      PARAMETER(MPITEST_INTEGER=1, MPITEST_REAL=2)
      PARAMETER(MPITEST_DOUBLE_PRECISION=3, MPITEST_COMPLEX=4)
      PARAMETER(MPITEST_LOGICAL=5, MPITEST_CHARACTER=6)
      PARAMETER(MPITEST_DOUBLE_COMPLEX=9)
      PARAMETER(MPITEST_REAL2=10)
      PARAMETER(MPITEST_REAL4=11)
      PARAMETER(MPITEST_REAL8=12)
      PARAMETER(MPITEST_INTEGER1=13)
      PARAMETER(MPITEST_INTEGER2=14)
      PARAMETER(MPITEST_INTEGER4=15)
      PARAMETER(MPITEST_DATATYPE_MAX=15)


C  Global end token.  This delimits the end of specification
C  arrays

C  MAGIC NUMBERS FOR MESSAGE LENGTH SPECIFICATION
      INTEGER MPITEST_ADD_INC
      INTEGER MPITEST_MULT_INC
      INTEGER MPITEST_REPEAT
      INTEGER MPITEST_MIN_LENGTH

      PARAMETER(MPITEST_ADD_INC=-1, MPITEST_MULT_INC=-2)
      PARAMETER(MPITEST_REPEAT=-3, MPITEST_MIN_LENGTH=-3)

C  Definitions shared between the config arrays
C  The default length of specification arrays.  This number should be
C  set large enough to accommodate all foreseeable default specs.
      INTEGER MPITEST_CFGSIZ
      PARAMETER(MPITEST_CFGSIZ = 128)

      INTEGER MPITEST_END_TOKEN
      PARAMETER(MPITEST_END_TOKEN=-999999)


C  Definitions for the communicator config array
C    Communicator types
      INTEGER MPITEST_COMM_WORLD, MPITEST_COMM_SELF, MPITEST_COMM_CREATE
      INTEGER MPITEST_COMM_DUP, MPITEST_COMM_INTER, MPITEST_COMM_MERGE
      INTEGER MPITEST_COMM_SPLIT

      PARAMETER(MPITEST_COMM_WORLD=-10, MPITEST_COMM_SELF=-11)
      PARAMETER(MPITEST_COMM_CREATE=-12, MPITEST_COMM_SPLIT=-13)
      PARAMETER(MPITEST_COMM_DUP=-14, MPITEST_COMM_INTER=-15)
      PARAMETER(MPITEST_COMM_MERGE=-16)

C    Communicator sizes
      INTEGER MPITEST_COMM_ALL, MPITEST_COMM_ALLBUT1, MPITEST_COMM_HALF
      INTEGER MPITEST_COMM_ONE, MPITEST_COMM_RNKLST, MPITEST_COMM_COMINC
      INTEGER MPITEST_COMM_LASTRNK, MPITEST_COMM_COMMIN

      PARAMETER(MPITEST_COMM_ALL=-4, MPITEST_COMM_ALLBUT1=-3)
      PARAMETER( MPITEST_COMM_HALF=-2, MPITEST_COMM_ONE=-1)
      PARAMETER(MPITEST_COMM_LASTRNK = -5, MPITEST_COMM_RNKLST = -7)
      PARAMETER(MPITEST_COMM_COMINC = -6, MPITEST_COMM_COMMIN = -7)

C  The communicator config array
      INTEGER MPITEST_COMMS(MPITEST_CFGSIZ)
      INTEGER MPITEST_MPI_DATATYPES(MPITEST_CFGSIZ)
      INTEGER MPITEST_MESSAGE_LENGTHS(MPITEST_CFGSIZ)
      INTEGER MPITEST_TYPES(MPITEST_CFGSIZ)

C  Intercommunicator information
      INTEGER MPITEST_INTER
      INTEGER MPITEST_NOT_INTER

      PARAMETER(MPITEST_NOT_INTER=-1)

C  Definitions for global variables
      INTEGER MPITEST_NUMP, MPITEST_ME, MPITEST_CURRENT_RANK
      INTEGER MPITEST_VERBOSE
      INTEGER MPITEST_STDOUT, MPITEST_STDOUTFILE
      INTEGER BREAKPOINTS(2 * MPITEST_CFGSIZ)

C  Common block
      COMMON /MPIT/ MPITEST_NUMP, MPITEST_ME, MPITEST_CURRENT_RANK, 
     &  MPITEST_COMMS, MPITEST_VERBOSE,
     &  MPITEST_MPI_DATATYPES,
     &  MPITEST_MESSAGE_LENGTHS, MPITEST_INTER,
     &  MPITEST_TYPES, MPITEST_STDOUTFILE,
     &  MPITEST_STDOUT, BREAKPOINTS
