C -----------------------------------------------------------------------------
C MESSAGE PASSING INTERFACE TEST CASE SUITE
C 
C Copyright - 1996 Intel Corporation
C 
C Intel Corporation hereby grants a non-exclusive license under Intel's
C copyright to copy, modify and distribute this software for any purpose 
C and without fee, provided that the above copyright notice and the following
C paragraphs appear on all copies.
C 
C Intel Corporation makes no representation that the test cases comprising
C this suite are correct or are an accurate representation of any standard.
C 
C IN NO EVENT SHALL INTEL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT OR
C SPECULATIVE DAMAGES, (INCLUDING WITHOUT LIMITING THE FOREGOING, CONSEQUENTIAL,
C INCIDENTAL AND SPECIAL DAMAGES) INCLUDING, BUT NOT LIMITED TO INFRINGEMENT,
C LOSS OF USE, BUSINESS INTERRUPTIONS, AND LOSS OF PROFITS, IRRESPECTIVE OF
C WHETHER INTEL HAS ADVANCE NOTICE OF THE POSSIBILITY OF ANY SUCH DAMAGES.
C 
C INTEL CORPORATION SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT
C LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
C PARTICULAR PURPOSE AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED HEREUNDER
C IS ON AN "AS IS" BASIS AND INTEL CORPORATION HAS NO OBLIGATION TO PROVIDE
C MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
C 
C -----------------------------------------------------------------------------
C******************************************************************************
C      Environment test for MPI.
C
C This test verifies that all required constants and routines are defined
C correctly for the MPI implementation.  Most errors will be found at
C compile time; a few (such as error codes) are validated by running the
C test.
C
C According to the MPI spic (sec 2.5.1) all Fortran named constants
C except MPI_BOTTOM can be used in a PARAMETER statement.  This test does
C not do so, so the result of this test should be compared to that
C of MPI_defs, which does use parameter statements.
C
C
C Test history:
C    1  01/12/96     gt   Created
C
C******************************************************************************

#include "foptions.h"

 
      FUNCTION USERFUNCTION(INVEC, INOUTVEC, LEN, TYPE) 
      INTEGER INVEC(*) 
      INTEGER INOUTVEC(*) 
      INTEGER LEN 
      INTEGER TYPE 
 
      END 
 
      FUNCTION HANDLERFUNCTION(COMMIN, CODE) 
      INTEGER COMMIN 
      INTEGER CODE
 
      END


      PROGRAM MAIN

      INCLUDE "mpitestf.h"
      INCLUDE "externalf.h"
      INCLUDE "mpif.h"
      EXTERNAL USERFUNCTION
      EXTERNAL HANDLERFUNCTION

      INTEGER  FAIL
      INTEGER  PASS
      INTEGER  ERR

 
      CHARACTER*(IOSIZE) INFOBUF
      CHARACTER*32  TESTNAME
C                                 Variables used by test
C                                 Remainder are args to MPI calls/constants.
 

      INTEGER  IERROR
      INTEGER  COUNT1 
      INTEGER  COUNT2
      INTEGER  LEVEL
      INTEGER  DIMS
      INTEGER  NDIMS
      INTEGER  MAXDIMS
      INTEGER  MAXINDEX
      INTEGER  MAXEDGES
      INTEGER  NEDGES
      INTEGER  COORDS
      INTEGER  NNODES
      INTEGER  HIGH
      INTEGER  NEIGHBORS
      INTEGER  NNEIGHBORS
      INTEGER  MAXNEIGHBORS
      INTEGER  PERIODS
      INTEGER  DEST   
      INTEGER  SOURCE
      INTEGER  DIRECTION
      INTEGER  ERRORCODE
      INTEGER  ERRORCLASS
      INTEGER  STRIDE
      INTEGER  TAG1
      INTEGER  TAG2
      INTEGER  ATTRIBUTE_VAL
      INTEGER  ATTR1
      INTEGER  BUF1
      INTEGER  BUF2
      INTEGER  INDICIE_ARRAY(10)
      INTEGER  LENGTH_ARRAY(10)
      INTEGER  INDEX_ARRAY(10)
      INTEGER  EDGE_ARRAY(10)
      INTEGER  DISPLACEMENT_ARRAY(10)
      INTEGER  SIZE
      INTEGER  RANK1
      INTEGER  RANK2
      INTEGER  RANK_ARRAY(10)
      INTEGER  REORDER
      INTEGER  ROOT
      INTEGER  LENGTH
      INTEGER  POSITION
      INTEGER  DISPLS
      INTEGER  DISPLS1
      INTEGER  DISPLS2
      INTEGER  KEYVAL
      INTEGER  COLOR
      INTEGER  LOCATION
      INTEGER  LEADER1
      INTEGER  LEADER2
      INTEGER  RESULT
      INTEGER  STATE
      INTEGER  BOTTOM
      INTEGER  ERRHANDLER
 
      INTEGER  RANGES(10,3)

      CHARACTER*(MPI_MAX_ERROR_STRING) STRING
      CHARACTER*(MPI_MAX_PROCESSOR_NAME) NAME
 
      REAL	TIME

      LOGICAL  FLAG
      LOGICAL  COMMUTE

      INTEGER  COMM1
      INTEGER  COMM2
      INTEGER  NEWCOMM
 
      INTEGER  DATATYPE
      INTEGER  NEWTYPE
      INTEGER  OLDTYPE
      INTEGER  SENDTYPE
      INTEGER  RECVTYPE
      INTEGER  TYPE_ARRAY(10)
 
      INTEGER  STATUS(MPI_STATUS_SIZE)
      INTEGER  STATUS_ARRAY(MPI_STATUS_SIZE,10)
 
      INTEGER  REQUEST
      INTEGER  REQUEST_ARRAY(10)
 
 
      INTEGER  ADDRESS 
      INTEGER  ASTRIDE
      INTEGER  DISPLACEMENT
      INTEGER  DISPLACEMENT_AARRAY(10)
      INTEGER  EXTENT
      INTEGER  ASIZE

      INTEGER  GROUP1
      INTEGER  GROUP2
      INTEGER  NEWGROUP

      INTEGER  OP

C
C     Constant definitions are tested by using them in a parameter statement.
C
      INTEGER MPIT_SUCCESS
      INTEGER MPIT_ERR_BUFFER
      INTEGER MPIT_ERR_COUNT
      INTEGER MPIT_ERR_TYPE
      INTEGER MPIT_ERR_TAG
      INTEGER MPIT_ERR_COMM
      INTEGER MPIT_ERR_RANK
      INTEGER MPIT_ERR_REQUEST
      INTEGER MPIT_ERR_ROOT
      INTEGER MPIT_ERR_GROUP
      INTEGER MPIT_ERR_OP
      INTEGER MPIT_ERR_TOPOLOGY
      INTEGER MPIT_ERR_DIMS
      INTEGER MPIT_ERR_ARG
      INTEGER MPIT_ERR_UNKNOWN
      INTEGER MPIT_ERR_TRUNCATE
      INTEGER MPIT_ERR_OTHER
      INTEGER MPIT_ERR_INTERN
      INTEGER MPIT_ERR_PENDING
      INTEGER MPIT_ERR_IN_STATUS
      INTEGER MPIT_ERR_LASTCODE
      INTEGER MPIT_PROC_NULL
      INTEGER MPIT_ANY_SOURCE
      INTEGER MPIT_ANY_TAG
      INTEGER MPIT_UNDEFINED
      INTEGER MPIT_BSEND_OVERHEAD
      INTEGER MPIT_KEYVAL_INVALID
      INTEGER MPIT_STATUS_SIZE
      INTEGER MPIT_SOURCE
      INTEGER MPIT_TAG
      INTEGER MPIT_ERROR
      INTEGER MPIT_ERRORS_ARE_FATAL
      INTEGER MPIT_ERRORS_RETURN
      INTEGER MPIT_INTEGER
      INTEGER MPIT_REAL
      INTEGER MPIT_DOUBLE_PRECISION
      INTEGER MPIT_COMPLEX
      INTEGER MPIT_CHARACTER
      INTEGER MPIT_BYTE
      INTEGER MPIT_PACKED
      INTEGER MPIT_2REAL
      INTEGER MPIT_2DOUBLE_PRECISION
      INTEGER MPIT_2INTEGER
      INTEGER MPIT_UB
      INTEGER MPIT_LB
      INTEGER MPIT_COMM_WORLD
      INTEGER MPIT_COMM_SELF
      INTEGER MPIT_IDENT
      INTEGER MPIT_CONGRUENT
      INTEGER MPIT_SIMILAR
      INTEGER MPIT_UNEQUAL
      INTEGER MPIT_TAG_UB
      INTEGER MPIT_IO
      INTEGER MPIT_HOST
      INTEGER MPIT_WTIME_IS_GLOBAL
      INTEGER MPIT_MAX
      INTEGER MPIT_MIN
      INTEGER MPIT_SUM
      INTEGER MPIT_PROD
      INTEGER MPIT_MAXLOC
      INTEGER MPIT_MINLOC
      INTEGER MPIT_BAND
      INTEGER MPIT_BOR
      INTEGER MPIT_BXOR
      INTEGER MPIT_LAND
      INTEGER MPIT_LOR
      INTEGER MPIT_LXOR
      INTEGER MPIT_GROUP_NULL
      INTEGER MPIT_COMM_NULL
      INTEGER MPIT_DATATYPE_NULL
      INTEGER MPIT_REQUEST_NULL
      INTEGER MPIT_OP_NULL
      INTEGER MPIT_ERRHANDLER_NULL
      INTEGER MPIT_GROUP_EMPTY
      INTEGER MPIT_GRAPH
      INTEGER MPIT_CART



 99   FORMAT(A,INT_FMT)
 101  FORMAT(A,INT_FMT,A)

      FAIL = 0
      PASS = 0

C
C     Initialize the MPI environment
C
      CALL MPI_INIT(IERROR)
      IF (IERROR .NE. MPI_SUCCESS) THEN
        WRITE(INFOBUF,99) 'MPI_INIT() returned', IERROR
        CALL MPITEST_MESSAGE(MPITEST_FATAL, INFOBUF)
      END IF

C
C     Initialize the MPITEST environment
C
      CALL MPITEST_INIT(IERROR)
      TESTNAME = 'MPI_defs2'
      IF (MPITEST_ME .EQ. 0) THEN
C
C
C     Only one node need run this test.
C
        INFOBUF = 'Starting test '//TESTNAME
        CALL MPITEST_MESSAGE(MPITEST_INFO0, INFOBUF)

C
C      Ensure all error types are defined.
C
      ERR = MPI_SUCCESS
      IF (ERR .NE. 0) THEN
        WRITE (INFOBUF,101) 'MPI_SUCCESS=', MPI_SUCCESS ,' expected 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_BUFFER
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_BUFFER = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_BUFFER =',MPI_ERR_BUFFER,
     $         ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_COUNT
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_COUNT = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_COUNT =',MPI_ERR_COUNT,
     $         ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_TYPE
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_TYPE = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_TYPE =', MPI_ERR_TYPE,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_TAG
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_TAG = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_TAG =', MPI_ERR_TAG,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_COMM
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_COMM = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_COMM =', MPI_ERR_COMM,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_RANK
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_RANK = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_RANK =', MPI_ERR_RANK,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_REQUEST
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_REQUEST = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_REQUEST =', MPI_ERR_REQUEST,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_ROOT
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_ROOT = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_ROOT =', MPI_ERR_ROOT,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_GROUP
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_GROUP = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_GROUP =', MPI_ERR_GROUP,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_OP
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_OP = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_OP =', MPI_ERR_OP,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_TOPOLOGY
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_TOPOLOGY = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_TOPOLOGY =', MPI_ERR_TOPOLOGY,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_DIMS
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_DIMS = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_DIMS =', MPI_ERR_DIMS,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_ARG
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_ARG = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_ARG =', MPI_ERR_ARG,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_UNKNOWN
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_UNKNOWN = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_UNKNOWN =', MPI_ERR_UNKNOWN,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_TRUNCATE
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_TRUNCATE = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_TRUNCATE =', MPI_ERR_TRUNCATE,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_OTHER
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_OTHER = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_OTHER =', MPI_ERR_OTHER,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_INTERN
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_INTERN = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_INTERN =', MPI_ERR_INTERN,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      ERR = MPI_ERR_PENDING
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_PENDING = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF


      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_PENDING =', MPI_ERR_PENDING,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      ERR = MPI_ERR_IN_STATUS
      IF (ERR .EQ. 0) THEN
        INFOBUF = 'MPI_ERR_IN_STATUS = 0'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (ERR .GT. MPI_ERR_LASTCODE) THEN
        WRITE (INFOBUF,101) 'MPI_ERR_IN_STATUS =', MPI_ERR_IN_STATUS,
     $        ' exceeds MPI_ERR_LASTCODE'
        CALL MPITEST_MESSAGE(MPITEST_NONFATAL, INFOBUF)
        FAIL = FAIL + 1
      ELSE
        PASS = PASS + 1
      END IF

      IF (FAIL .EQ. -1) THEN

      MPIT_SUCCESS = MPI_SUCCESS
      MPIT_ERR_BUFFER = MPI_ERR_BUFFER
      MPIT_ERR_COUNT = MPI_ERR_COUNT
      MPIT_ERR_TYPE = MPI_ERR_TYPE
      MPIT_ERR_TAG = MPI_ERR_TAG
      MPIT_ERR_COMM = MPI_ERR_COMM
      MPIT_ERR_RANK = MPI_ERR_RANK
      MPIT_ERR_REQUEST = MPI_ERR_REQUEST
      MPIT_ERR_ROOT = MPI_ERR_ROOT
      MPIT_ERR_GROUP = MPI_ERR_GROUP
      MPIT_ERR_OP = MPI_ERR_OP
      MPIT_ERR_TOPOLOGY = MPI_ERR_TOPOLOGY
      MPIT_ERR_DIMS = MPI_ERR_DIMS
      MPIT_ERR_ARG = MPI_ERR_ARG
      MPIT_ERR_UNKNOWN = MPI_ERR_UNKNOWN
      MPIT_ERR_TRUNCATE = MPI_ERR_TRUNCATE
      MPIT_ERR_OTHER = MPI_ERR_OTHER
      MPIT_ERR_INTERN = MPI_ERR_INTERN
      MPIT_ERR_PENDING = MPI_ERR_PENDING
      MPIT_ERR_IN_STATUS = MPI_ERR_IN_STATUS
      MPIT_ERR_LASTCODE = MPI_ERR_LASTCODE
      MPIT_PROC_NULL = MPI_PROC_NULL
      MPIT_ANY_SOURCE = MPI_ANY_SOURCE
      MPIT_ANY_TAG = MPI_ANY_TAG
      MPIT_UNDEFINED = MPI_UNDEFINED
      MPIT_BSEND_OVERHEAD = MPI_BSEND_OVERHEAD
      MPIT_KEYVAL_INVALID = MPI_KEYVAL_INVALID
      MPIT_STATUS_SIZE = MPI_STATUS_SIZE
      MPIT_SOURCE = MPI_SOURCE
      MPIT_TAG = MPI_TAG
      MPIT_ERROR = MPI_ERROR
      MPIT_ERRORS_ARE_FATAL = MPI_ERRORS_ARE_FATAL
      MPIT_ERRORS_RETURN = MPI_ERRORS_RETURN
      MPIT_INTEGER = MPI_INTEGER
      MPIT_REAL = MPI_REAL
      MPIT_DOUBLE_PRECISION = MPI_DOUBLE_PRECISION
      MPIT_COMPLEX = MPI_COMPLEX
      MPIT_CHARACTER = MPI_CHARACTER
      MPIT_BYTE = MPI_BYTE
      MPIT_PACKED = MPI_PACKED
      MPIT_2REAL = MPI_2REAL
      MPIT_2DOUBLE_PRECISION = MPI_2DOUBLE_PRECISION
      MPIT_2INTEGER = MPI_2INTEGER
      MPIT_UB = MPI_UB
      MPIT_LB = MPI_LB
      MPIT_COMM_WORLD = MPI_COMM_WORLD
      MPIT_COMM_SELF = MPI_COMM_SELF
      MPIT_IDENT = MPI_IDENT
      MPIT_CONGRUENT = MPI_CONGRUENT
      MPIT_SIMILAR = MPI_SIMILAR
      MPIT_UNEQUAL = MPI_UNEQUAL
      MPIT_TAG_UB = MPI_TAG_UB
      MPIT_IO = MPI_IO
      MPIT_HOST = MPI_HOST
      MPIT_WTIME_IS_GLOBAL = MPI_WTIME_IS_GLOBAL
      MPIT_MAX = MPI_MAX
      MPIT_MIN = MPI_MIN
      MPIT_SUM = MPI_SUM
      MPIT_PROD = MPI_PROD
      MPIT_MAXLOC = MPI_MAXLOC
      MPIT_MINLOC = MPI_MINLOC
      MPIT_BAND = MPI_BAND
      MPIT_BOR = MPI_BOR
      MPIT_BXOR = MPI_BXOR
      MPIT_LAND = MPI_LAND
      MPIT_LOR = MPI_LOR
      MPIT_LXOR = MPI_LXOR
      MPIT_GROUP_NULL = MPI_GROUP_NULL
      MPIT_COMM_NULL = MPI_COMM_NULL
      MPIT_DATATYPE_NULL = MPI_DATATYPE_NULL
      MPIT_REQUEST_NULL = MPI_REQUEST_NULL
      MPIT_OP_NULL = MPI_OP_NULL
      MPIT_ERRHANDLER_NULL = MPI_ERRHANDLER_NULL
      MPIT_GROUP_EMPTY = MPI_GROUP_EMPTY
      MPIT_GRAPH = MPI_GRAPH
      MPIT_CART = MPI_CART
C
C     THE REMAINDER OF THESE CALLS ARE HERE ONLY TO FORCE THE LINKER
C     TO RESOLVE REFERENCES TO ALL MPI FUNCTIONS - IF THIS COMPILES
C     THEN IT PASSES.
C      
C       A.9 POINT-TO-POINT COMMUNICATION BINDINGS
C      
      CALL MPI_SEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1, IERROR)
      CALL MPI_RECV(BUF1, COUNT1, DATATYPE, SOURCE, TAG1, COMM1,
     $              STATUS, IERROR)
      CALL MPI_GET_COUNT(STATUS, DATATYPE, COUNT1, IERROR)
      CALL MPI_BSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1, IERROR)
      CALL MPI_SSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1, IERROR)
      CALL MPI_RSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1, IERROR)
      CALL MPI_BUFFER_ATTACH(BUF1, SIZE, IERROR)
      CALL MPI_BUFFER_DETACH(BUF1, SIZE, IERROR)
      CALL MPI_ISEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1, REQUEST,
     $              IERROR)
      CALL MPI_IBSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_ISSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_IRSEND(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_IRECV(BUF1, COUNT1, DATATYPE, SOURCE, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_WAIT(REQUEST, STATUS, IERROR)
      CALL MPI_TEST(REQUEST, FLAG, STATUS, IERROR)
      CALL MPI_REQUEST_FREE(REQUEST, IERROR)
      CALL MPI_WAITANY(COUNT1, REQUEST_ARRAY, TAG1, STATUS, IERROR)
      CALL MPI_TESTANY(COUNT1, REQUEST_ARRAY, TAG1, FLAG, STATUS,
     $              IERROR)
      CALL MPI_WAITALL(COUNT1, REQUEST_ARRAY, STATUS_ARRAY,
     $              IERROR)
      CALL MPI_TESTALL(COUNT1, REQUEST_ARRAY, FLAG, STATUS_ARRAY,
     $              IERROR)
      CALL MPI_WAITSOME(COUNT1, REQUEST_ARRAY, COUNT2, INDICIE_ARRAY,
     $              STATUS_ARRAY, IERROR)
      CALL MPI_TESTSOME(COUNT1, REQUEST_ARRAY, COUNT2, INDICIE_ARRAY,
     $              STATUS_ARRAY, IERROR)
      CALL MPI_IPROBE(SOURCE, TAG1, COMM1, FLAG, STATUS, IERROR)
      CALL MPI_PROBE(SOURCE, TAG1, COMM1, STATUS, IERROR)
      CALL MPI_CANCEL(REQUEST, IERROR)
      CALL MPI_TEST_CANCELLED(STATUS, FLAG, IERROR)
      CALL MPI_SEND_INIT(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_BSEND_INIT(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_SSEND_INIT(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_RSEND_INIT(BUF1, COUNT1, DATATYPE, DEST, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_RECV_INIT(BUF1, COUNT1, DATATYPE, SOURCE, TAG1, COMM1,
     $              REQUEST, IERROR)
      CALL MPI_START(REQUEST, IERROR)
      CALL MPI_STARTALL(COUNT1, REQUEST_ARRAY, IERROR)
      CALL MPI_SENDRECV(BUF1, COUNT1, SENDTYPE, DEST, TAG1, BUF2,
     $            COUNT2, RECVTYPE, SOURCE, TAG2, COMM1, STATUS, IERROR)
      CALL MPI_SENDRECV_REPLACE(BUF1, COUNT1, DATATYPE, DEST, TAG1,
     $              SOURCE, TAG2, COMM1, STATUS, IERROR)
      CALL MPI_TYPE_CONTIGUOUS(COUNT1, OLDTYPE, NEWTYPE, IERROR)
      CALL MPI_TYPE_VECTOR(COUNT1, LENGTH, STRIDE, OLDTYPE, NEWTYPE,
     $              IERROR)
      CALL MPI_TYPE_HVECTOR(COUNT1, LENGTH, ASTRIDE, OLDTYPE, NEWTYPE,
     $              IERROR)
      CALL MPI_TYPE_INDEXED(COUNT1, LENGTH_ARRAY,
     $              DISPLACEMENT_ARRAY, OLDTYPE, NEWTYPE, IERROR)
      CALL MPI_TYPE_HINDEXED(COUNT1, LENGTH_ARRAY,
     $              DISPLACEMENT_AARRAY, OLDTYPE, NEWTYPE, IERROR)
      CALL MPI_TYPE_STRUCT(COUNT1, LENGTH_ARRAY,
     $              DISPLACEMENT_AARRAY, TYPE_ARRAY, NEWTYPE,
     $              IERROR)
      CALL MPI_ADDRESS(LOCATION, ADDRESS, IERROR)
      CALL MPI_TYPE_EXTENT(DATATYPE, EXTENT, IERROR)
      CALL MPI_TYPE_SIZE(DATATYPE, SIZE, IERROR)
      CALL MPI_TYPE_LB(DATATYPE, DISPLACEMENT, IERROR)
      CALL MPI_TYPE_UB(DATATYPE, DISPLACEMENT, IERROR)
      CALL MPI_TYPE_COMMIT(DATATYPE, IERROR)
      CALL MPI_TYPE_FREE(DATATYPE, IERROR)
      CALL MPI_GET_ELEMENTS(STATUS, DATATYPE, COUNT1, IERROR)
      CALL MPI_PACK(BUF1, COUNT1, DATATYPE, BUF2, SIZE, POSITION, 
     $              COMM1, IERROR)
      CALL MPI_UNPACK(BUF1, SIZE, POSITION, BUF2, COUNT2, DATATYPE,
     $              COMM1, IERROR)
      CALL MPI_PACK_SIZE(COUNT1, DATATYPE, COMM1, SIZE, IERROR)

C      
C       A.10 COLLECTIVE COMMUNICATION BINDINGS
C      
      CALL MPI_BARRIER(COMM1, IERROR)
      CALL MPI_BCAST(BUF1, COUNT1, DATATYPE, ROOT, COMM1, IERROR)
      CALL MPI_GATHER(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, RECVTYPE,
     $              ROOT, COMM1, IERROR) 
      CALL MPI_GATHERV(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, DISPLS,
     $              RECVTYPE, ROOT, COMM1, IERROR) 
      CALL MPI_SCATTER(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, RECVTYPE,
     $              ROOT, COMM1, IERROR)
      CALL MPI_SCATTERV(BUF1, COUNT1, DISPLS, DATATYPE, BUF2, COUNT2,
     $              RECVTYPE, ROOT, COMM1, IERROR)
      CALL MPI_ALLGATHER(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, RECVTYPE,
     $              COMM1, IERROR)
      CALL MPI_ALLGATHERV(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, DISPLS,
     $              RECVTYPE, COMM1, IERROR)
      CALL MPI_ALLTOALL(BUF1, COUNT1, DATATYPE, BUF2, COUNT2, RECVTYPE,
     $              COMM1, IERROR)
      CALL MPI_ALLTOALLV(BUF1, COUNT1, DISPLS1, DATATYPE, BUF2, COUNT2,
     $              DISPLS2, RECVTYPE, COMM1, IERROR)
      CALL MPI_REDUCE(BUF1, BUF2, COUNT1, DATATYPE, OP, ROOT, COMM1,
     $              IERROR)
      CALL MPI_OP_CREATE(USERFUNCTION, COMMUTE, OP, IERROR)
      CALL MPI_OP_FREE(OP, IERROR)
      CALL MPI_ALLREDUCE(BUF1, BUF2, COUNT1, DATATYPE, OP, COMM1,
     $              IERROR)
      CALL MPI_REDUCE_SCATTER(BUF1, BUF2, COUNT2, DATATYPE, OP, COMM1,
     $              IERROR)
      CALL MPI_SCAN(BUF1, BUF2, COUNT1, DATATYPE, OP, COMM1, IERROR)

C      
C       A.11 GROUPS, CONTEXTS AND COMMUNICATORS BINDINGS
C      
      CALL MPI_GROUP_SIZE(GROUP1, SIZE, IERROR)
      CALL MPI_GROUP_RANK(GROUP1, RANK1, IERROR)
      CALL MPI_GROUP_TRANSLATE_RANKS (GROUP1, COUNT1, RANK1, GROUP2,
     $              RANK2, IERROR)
      CALL MPI_GROUP_COMPARE(GROUP1, GROUP2, RESULT, IERROR)
      CALL MPI_COMM_GROUP(COMM1, GROUP1, IERROR)
      CALL MPI_GROUP_UNION(GROUP1, GROUP2, NEWGROUP, IERROR)
      CALL MPI_GROUP_INTERSECTION(GROUP1, GROUP2, NEWGROUP, IERROR)
      CALL MPI_GROUP_DIFFERENCE(GROUP1, GROUP2, NEWGROUP, IERROR)
      CALL MPI_GROUP_INCL(GROUP1, COUNT1, RANK_ARRAY, NEWGROUP,
     $              IERROR)
      CALL MPI_GROUP_EXCL(GROUP1, COUNT1, RANK_ARRAY, NEWGROUP,
     $              IERROR)
      CALL MPI_GROUP_RANGE_INCL(GROUP1, COUNT1, RANGES, NEWGROUP,
     $              IERROR)
      CALL MPI_GROUP_RANGE_EXCL(GROUP1, COUNT1, RANGES, NEWGROUP,
     $              IERROR)
      CALL MPI_GROUP_FREE(GROUP1, IERROR)
      CALL MPI_COMM_SIZE(COMM1, SIZE, IERROR)
      CALL MPI_COMM_RANK(COMM1, RANK1, IERROR)
      CALL MPI_COMM_COMPARE(COMM1, COMM2, RESULT, IERROR)
      CALL MPI_COMM_DUP(COMM1, NEWCOMM, IERROR)
      CALL MPI_COMM_CREATE(COMM1, GROUP1, NEWCOMM, IERROR)
      CALL MPI_COMM_SPLIT(COMM1, COLOR, KEYVAL, NEWCOMM, IERROR)
      CALL MPI_COMM_FREE(COMM1, IERROR)
      CALL MPI_COMM_TEST_INTER(COMM1, FLAG, IERROR)
      CALL MPI_COMM_REMOTE_SIZE(COMM1, SIZE, IERROR)
      CALL MPI_COMM_REMOTE_GROUP(COMM1, GROUP1, IERROR)
      CALL MPI_INTERCOMM_CREATE(COMM1, LEADER1, COMM2, LEADER2, TAG1,
     $              NEWCOMM, IERROR)
      CALL MPI_INTERCOMM_MERGE(COMM1, HIGH, NEWCOMM, IERROR)
      CALL MPI_KEYVAL_CREATE(MPI_NULL_COPY_FN, MPI_NULL_DELETE_FN, 
     $              KEYVAL, STATE, IERROR)
      CALL MPI_KEYVAL_FREE(KEYVAL, IERROR)
      CALL MPI_ATTR_PUT(COMM1, KEYVAL, ATTRIBUTE_VAL, IERROR)
      CALL MPI_ATTR_GET(COMM1, KEYVAL, ATTRIBUTE_VAL, FLAG, IERROR)
      CALL MPI_ATTR_DELETE(COMM1, KEYVAL, IERROR)

C      
C       A.12 PROCESS TOPOLOGIES BINDINGS
C      
      CALL MPI_CART_CREATE(COMM1, NDIMS, DIMS, PERIODS, REORDER, COMM2,
     $              IERROR)
      CALL MPI_DIMS_CREATE(NNODES, NDIMS, DIMS, IERROR)
      CALL MPI_GRAPH_CREATE(COMM1, NNODES, INDEX_ARRAY, EDGE_ARRAY,
     $              REORDER, COMM2, IERROR)
      CALL MPI_TOPO_TEST(COMM1, RESULT, IERROR)
      CALL MPI_GRAPHDIMS_GET(COMM1, NNODES, NEDGES, IERROR)
      CALL MPI_GRAPH_GET(COMM1, MAXINDEX, MAXEDGES, INDEX_ARRAY,
     $              EDGE_ARRAY, IERROR)
      CALL MPI_CARTDIM_GET(COMM1, NDIMS, IERROR)
      CALL MPI_CART_GET(COMM1, MAXDIMS, DIMS, PERIODS, COORDS, IERROR)
      CALL MPI_CART_RANK(COMM1, COORDS, RANK1, IERROR)
      CALL MPI_CART_COORDS(COMM1, RANK1, MAXDIMS, COORDS, IERROR)
      CALL MPI_GRAPH_NEIGHBORS_COUNT(COMM1, RANK1, NNEIGHBORS, IERROR)
      CALL MPI_GRAPH_NEIGHBORS(COMM1, RANK1, MAXNEIGHBORS, NEIGHBORS,
     $              IERROR)
      CALL MPI_CART_SHIFT(COMM1, DIRECTION, DISPLS, RANK1, RANK2,
     $              IERROR)
      CALL MPI_CART_SUB(COMM1, DIMS, NEWCOMM, IERROR)
      CALL MPI_CART_MAP(COMM1, NDIMS, DIMS, PERIODS, RANK1, IERROR)
      CALL MPI_GRAPH_MAP(COMM1, NNODES, INDEX_ARRAY, EDGE_ARRAY,
     $              RANK1, IERROR)

C      
C       A.13 ENVIRONMENTAL INQUIRY BINDINGS
C      
      CALL MPI_GET_PROCESSOR_NAME(NAME, RESULT, IERROR)
      CALL MPI_ERRHANDLER_CREATE(HANDLERFUNCTION, ERRHANDLER, IERROR)
      CALL MPI_ERRHANDLER_SET(COMM1, ERRHANDLER, IERROR)
      CALL MPI_ERRHANDLER_GET(COMM1, ERRHANDLER, IERROR)
      CALL MPI_ERRHANDLER_FREE(ERRHANDLER, IERROR)
      CALL MPI_ERROR_STRING(ERRORCODE, STRING, RESULT, IERROR)
      CALL MPI_ERROR_CLASS(ERRORCODE, ERRORCLASS, IERROR)
      TIME = MPI_WTIME(IERROR)
      TIME = MPI_WTICK(IERROR)
      CALL MPI_INIT(IERROR)
      CALL MPI_FINALIZE(IERROR)
      CALL MPI_INITIALIZED(FLAG, IERROR)
      CALL MPI_ABORT(COMM1, ERRORCODE, IERROR)

C      
C       A.14 PROFILING BINDINGS
C      
      CALL MPI_PCONTROL(LEVEL, ERRORCODE, IERROR)


      END IF
      END IF

C
C     Report overall results
C
      CALL MPITEST_REPORT(PASS, FAIL, 0, TESTNAME)

      CALL MPI_FINALIZE(IERROR)

      END
