#include "foptions.h"

      SUBROUTINE SET_DEFAULT_OPS(OP_ARRAY, NUMBER)
C ************************************************************************
C  Sets up the default operation array.  Returns the number of default 
C  operations.
C ************************************************************************
      INCLUDE 'mpitestf.h'
      INCLUDE 'mpif.h'

      INTEGER OP_ARRAY(10)
      INTEGER NUMBER


      OP_ARRAY(1) = MPI_MAXLOC
      OP_ARRAY(2) = MPI_MINLOC
  
      NUMBER = 2

      END


      SUBROUTINE HAS_OP(OP, TEST_TYPE, HASOP)
C ************************************************************************
C Determines whether a particular operation may be applied to a particular 
C data type, as specified in section 4.9.2 of the MPI Standard.
C ************************************************************************
      INCLUDE 'mpitestf.h'
      INCLUDE 'externalf.h'

      INTEGER OP
      INTEGER TEST_TYPE
      LOGICAL HASOP

      IF ((TEST_TYPE .EQ. MPITEST_INTEGER) .OR.
     $    (TEST_TYPE .EQ. MPITEST_REAL) .OR.
     $    (TEST_TYPE .EQ. MPITEST_DOUBLE_PRECISION)) THEN
        HASOP = .TRUE.
      ELSE
        HASOP = .FALSE.
      END IF

      END


      SUBROUTINE APPLY_INT_OP(OP_INDEX, X1, X2, ANSWER)
C ***************************************************************************
C Applies a binary operator to the two integers x1 and x2, returning the 
C result.  The binary operation is determined by the integer op_index.  The 
C mapping of op_index to operation is determined by the array 
C MPITEST_default_ops[], which is set at runtime in the main test code.
C ***************************************************************************
      INTEGER OP_INDEX
      INTEGER X1
      INTEGER X2
      INTEGER ANSWER(2)
  
      IF (OP_INDEX .EQ. 1) THEN
C       maximum
        ANSWER(1) = MAX(X1, X2)
        ANSWER(2) = MAX(X1, X2)
      ELSE IF (OP_INDEX .EQ. 2) THEN
C       minimum
        ANSWER(1) = MIN(X1, X2)
        ANSWER(2) = MIN(X1, X2)
      END IF
      END

      SUBROUTINE APPLY_DOUBLE_OP(OP_INDEX, X1, X2, ANSWER)
C ***************************************************************************
C Applies a binary operator to the two doubles x1 and x2, returning the 
C result.  The binary operation is determined by the integer op_index.  The 
C mapping of op_index to operation is determined by the array 
C MPITEST_default_ops[], which is set at runtime in the main test code.
C ***************************************************************************
      INTEGER OP_INDEX
      DOUBLE PRECISION X1
      DOUBLE PRECISION X2
      DOUBLE PRECISION ANSWER(2)

      IF (OP_INDEX .EQ. 1) THEN
C       maximum
        ANSWER(1) = MAX(X1, X2)
        ANSWER(2) = MAX(X1, X2)
      ELSE IF (OP_INDEX .EQ. 2) THEN
C       minimum
        ANSWER(1) = MIN(X1, X2)
        ANSWER(2) = MIN(X1, X2)
      END IF
      END


      SUBROUTINE APPLY_REAL_OP(OP_INDEX, X1, X2, ANSWER)
C ***************************************************************************
C Applies a binary operator to the two real x1 and x2, returning the 
C result.  The binary operation is determined by the integer op_index.  The 
C mapping of op_index to operation is determined by the array 
C MPITEST_default_ops[], which is set at runtime in the main test code.
C ***************************************************************************
      INTEGER OP_INDEX
      REAL X1
      REAL X2
      REAL ANSWER(2)

      IF (OP_INDEX .EQ. 1) THEN
C       maximum
        ANSWER(1) = MAX(X1, X2)
        ANSWER(2) = MAX(X1, X2)
      ELSE IF (OP_INDEX .EQ. 2) THEN
C       minimum
        ANSWER(1) = MIN(X1, X2)
        ANSWER(2) = MIN(X1, X2)
      END IF
      END


      SUBROUTINE GET_REDUCE_ANSWER(OP_INDEX, NUMP, ANSWER, TYPE)
C ************************************************************************
C Apply the binary operation specified by op_index to the numbers 
C (0, 1, 2, ..., nump-1), and fill in the dataTamplate object based on the 
C results.  The mapping of op_index to operation is determined by the array 
C MPITEST_default_ops[], which is set at runtime in the main test code. 
C In order for the answer produced by this routine to match the
C answer generated by the MPI_Reduce() operation in the test code, the
C send buffer of process with rank "i" must have been initialized with "i". 
C 
C This routine applies the operation to both integers and to doubles, 
C in case the double and float buffers are initialized differently than the 
C integer buffers.
C ************************************************************************
      INCLUDE 'mpitestf.h'
      INCLUDE 'externalf.h'

      INTEGER OP_INDEX
      INTEGER NUMP, TYPE
      MPITEST_BUF_TYPE ANSWER(2)

      INTEGER I1, I2
      REAL    R1, R2
      DOUBLE PRECISION D1, D2

      EXTERNAL APPLY_INT_OP
      EXTERNAL APPLY_REAL_OP
      EXTERNAL APPLY_DOUBLE_OP

      IF (NUMP .EQ. 1) THEN
        CALL MPITEST_DATATEMPLATE_INIT_POS(ANSWER, 1, 1, TYPE)
        CALL MPITEST_DATATEMPLATE_INIT_POS(ANSWER, 1, 2, TYPE)
        RETURN
      END IF

      I1 = 1
      I2 = 2

      R1 = 1.0
      R2 = 2.0

      D1 = 1.0
      D2 = 2.0

      IF (TYPE .EQ. MPITEST_INTEGER) THEN
         CALL APPLY_INT_OP(OP_INDEX, I1, I2, ANSWER)
      ELSE IF (TYPE .EQ. MPITEST_REAL) THEN
         CALL APPLY_REAL_OP(OP_INDEX, R1, R2, ANSWER)
      ELSE IF (TYPE .EQ. MPITEST_DOUBLE_PRECISION) THEN
         CALL APPLY_DOUBLE_OP(OP_INDEX, D1, D2, ANSWER)
      END IF

      IF (TYPE .EQ. MPITEST_INTEGER) THEN
         I1 = 3
         DO 100 I2=3, NUMP
           IF (I2 .GT. NUMP) GO TO 101
           IF ((I1 .GT. 2) .AND. (OP_INDEX .EQ. 4)) I1=1
           CALL APPLY_INT_OP(OP_INDEX, ANSWER, I1, ANSWER)
           I1 = I1 + 1
 100     CONTINUE
 101     CONTINUE
      ELSE IF (TYPE .EQ. MPITEST_REAL) THEN
         R1 = 3
         DO 200 R2=3, NUMP
           IF (R2 .GT. NUMP) GO TO 101
           IF ((R1 .GT. 2) .AND. (OP_INDEX .EQ. 4)) R1=1
           CALL APPLY_REAL_OP(OP_INDEX, ANSWER, R1, ANSWER)
           R1 = R1 + 1
 200     CONTINUE
 201     CONTINUE
      ELSE IF (TYPE .EQ. MPITEST_DOUBLE_PRECISION) THEN
         D1 = 3
         DO 400 D2=3, NUMP
           IF (D2 .GT. NUMP) GO TO 401
           IF ((D1 .GT. 2) .AND. (OP_INDEX .EQ. 4)) D1=1
           CALL APPLY_DOUBLE_OP(OP_INDEX, ANSWER, D1, ANSWER)
           D1 = D1 + 1
 400     CONTINUE
 401     CONTINUE
      END IF
  
      END

