/*-----------------------------------------------------------------------------
MESSAGE PASSING INTERFACE TEST CASE SUITE

Copyright - 1996 Intel Corporation

Intel Corporation hereby grants a non-exclusive license under Intel's
copyright to copy, modify and distribute this software for any purpose
and without fee, provided that the above copyright notice and the following
paragraphs appear on all copies.

Intel Corporation makes no representation that the test cases comprising
this suite are correct or are an accurate representation of any standard.

IN NO EVENT SHALL INTEL HAVE ANY LIABILITY FOR ANY DIRECT, INDIRECT OR
SPECULATIVE DAMAGES, (INCLUDING WITHOUT LIMITING THE FOREGOING, CONSEQUENTIAL,
INCIDENTAL AND SPECIAL DAMAGES) INCLUDING, BUT NOT LIMITED TO INFRINGEMENT,
LOSS OF USE, BUSINESS INTERRUPTIONS, AND LOSS OF PROFITS, IRRESPECTIVE OF
WHETHER INTEL HAS ADVANCE NOTICE OF THE POSSIBILITY OF ANY SUCH DAMAGES.

INTEL CORPORATION SPECIFICALLY DISCLAIMS ANY WARRANTIES INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
PARTICULAR PURPOSE AND NON-INFRINGEMENT.  THE SOFTWARE PROVIDED HEREUNDER
IS ON AN "AS IS" BASIS AND INTEL CORPORATION HAS NO OBLIGATION TO PROVIDE
MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS OR MODIFICATIONS.
-----------------------------------------------------------------------------*/
/*******************************************************************************
*      Environment test for MPI.
*
* This test verifies that all required constants and routines are defined
* correctly for the MPI implementation.  Most errors will be found at
* compile time; a few (such as error codes) are validated by running the
* test.
*
*
* Test history:
*    1  01/12/96     gt   Created
*
*******************************************************************************/
#include "mpitest_cfg.h"
#include "mpitest.h"

int    copyfunction (MPI_Comm *oldcomm, int *keyval, void *extra_state,
                                 void *attr_in, void *attr_out, int *flag)
{
}

int deletefunction ( MPI_Comm *comm, int *keyval, void *attr_val,
                                   void *extra_state )
{
}


void handlerfunction( MPI_Comm *oldcomm, int *code )
{
}

void userfunction( void *invec, void *inoutvec, int *len,
                                   MPI_Datatype *datatype)

{
}

main (argc, argv)

    int
	 argc;
    char
	*argv[];


{

    int			/* Variables used by the test */
	 fail,
	 pass;

    char
	 testmsg[150],
	 testname[128];

    int			/* Variables referenced by the calls */
	 err,
	 count1,
	 count2,
	 commute,
	 level,
	 dims,
	 ndims,
	 maxdims,
	 maxindex,
	 maxedges,
	 nedges,
	 coords,
	 nnodes,
	 high,
	 neighbors,
	 nneighbors,
	 maxneighbors,
	 periods,
	 dest,
	 source,
	 direction,
	 errorcode,
	 errorclass,
	 stride,
	 tag1,
	 tag2,
	 flag,
	 attribute_val,
	 attr1,
	 buffer1,
	 buffer2,
	 indicie_array[10],
	 length_array[10],
	 index_array[10],
	 edge_array[10],
	 displacement_array[10],
	 size,
	 rank1,
	 rank2,
	 rank_array[10],
	 reorder,
	 root,
	 length,
	 position,
	 displs,
	 displs1,
	 displs2,
	 keyval,
	 color,
	 location,
	 leader1,
	 leader2,
	 result,
	 state,
	*bottom;
	
    int
	 ranges[10][3];

    char
	 string[MPI_MAX_ERROR_STRING],
	 name[MPI_MAX_PROCESSOR_NAME];
	
    double
	 time;

    MPI_Comm
	 comm1,
	 comm2,
	 newcomm;
	
    MPI_Datatype
	 datatype,
	 newtype,
	 oldtype,
	 sendtype,
	 recvtype,
	 type_array[10];
 
    MPI_Status
	 status,
	 status_array[10];
 
    MPI_Request
	 request,
	 request_array[10];
 
 
    MPI_Aint
	 address, 
	 astride,
	 displacement,
	 displacement_aarray[10],
	 extent,
	 asize;

    MPI_Group
	  group1,
	  group2,
	  newgroup;

    MPI_Op
	  op;

    MPI_Errhandler
	 errhandler;


MPI_Init(&argc, &argv);
MPITEST_init(argc, argv);
sprintf( testname, "MPI_defs");
MPITEST_init( argc, argv);
if (MPITEST_me==0)
  {
    sprintf(testmsg, "Starting %s test", testname);
    MPITEST_message(MPITEST_INFO0, testmsg);
  }
else
  {
    /* only one node need run this, but must report overall results  */
    MPITEST_report(0, 0, 0, testname);

    MPI_Finalize();
    return 0;
  }

fail = 0;
pass = 0;

/*
**    Ensure all error types are defined.
*/
err = MPI_SUCCESS;
if (err != 0)
  {
    sprintf (testmsg,"MPI_SUCCESS = %d, expected 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_BUFFER;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_BUFFER = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_BUFFER = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_COUNT;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_COUNT = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_COUNT = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_TYPE;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_TYPE = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_TYPE = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_TAG;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_TAG = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_TAG = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_COMM;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_COMM = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_COMM = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_RANK;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_RANK = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_RANK = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;

err = MPI_ERR_REQUEST;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_REQUEST = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_REQUEST = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;

err = MPI_ERR_ROOT;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_ROOT = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_ROOT = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_GROUP;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_GROUP = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_GROUP = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_OP;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_OP = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_OP = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_TOPOLOGY;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_TOPOLOGY = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_TOPOLOGY = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_DIMS;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_DIMS = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_DIMS = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_ARG;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_ARG = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_ARG = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_UNKNOWN;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_UNKNOWN = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_UNKNOWN = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_TRUNCATE;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_TRUNCATE = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_TRUNCATE = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_OTHER;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_OTHER = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_OTHER = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_INTERN;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_INTERN = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_INTERN = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_PENDING;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_PENDING = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_PENDING = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;


err = MPI_ERR_IN_STATUS;
if (err == 0)
  {
    sprintf (testmsg,"MPI_ERR_IN_STATUS = 0");
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;
if (err > MPI_ERR_LASTCODE)
  {
    sprintf (testmsg,"MPI_ERR_IN_STATUS = %d, exceeds MPI_ERR_LASTCODE", err);
    MPITEST_message(MPITEST_NONFATAL, testmsg);
    fail++;
  }
else
    pass++;

if (fail == -1)      /* These are not executed, merely validating existance */
  {
bottom = MPI_BOTTOM;
err = MPI_TAG_UB;
err = MPI_PROC_NULL;
err = MPI_ANY_SOURCE;
err = MPI_ANY_TAG;
err = MPI_UNDEFINED;
err = MPI_BSEND_OVERHEAD;
err = MPI_KEYVAL_INVALID;
errhandler = MPI_ERRORS_ARE_FATAL;
errhandler = MPI_ERRORS_RETURN;

datatype = MPI_CHAR;
datatype = MPI_SHORT;
datatype = MPI_INT;
datatype = MPI_LONG;
datatype = MPI_UNSIGNED_CHAR;
datatype = MPI_UNSIGNED_SHORT;
datatype = MPI_UNSIGNED;
datatype = MPI_UNSIGNED_LONG;
datatype = MPI_FLOAT;
datatype = MPI_DOUBLE;
datatype = MPI_LONG_DOUBLE;
datatype = MPI_BYTE;
datatype = MPI_PACKED;

datatype = MPI_FLOAT_INT;
datatype = MPI_DOUBLE_INT;
datatype = MPI_LONG_INT;
datatype = MPI_2INT;
datatype = MPI_SHORT_INT;
datatype = MPI_LONG_DOUBLE_INT;

datatype = MPI_UB;
datatype = MPI_LB;

comm1 = MPI_COMM_WORLD;
comm1 = MPI_COMM_SELF;

err = MPI_IDENT;
err = MPI_CONGRUENT;
err = MPI_SIMILAR;
err = MPI_UNEQUAL;

err = MPI_IO;
err = MPI_HOST;
err = MPI_WTIME_IS_GLOBAL;

op = MPI_MAX;
op = MPI_MIN;
op = MPI_SUM;
op = MPI_PROD;
op = MPI_MAXLOC;
op = MPI_MINLOC;
op = MPI_BAND;
op = MPI_BOR;
op = MPI_BXOR;
op = MPI_LAND;
op = MPI_LOR;
op = MPI_LXOR;

group1 = MPI_GROUP_NULL;
comm1 = MPI_COMM_NULL;
datatype = MPI_DATATYPE_NULL;
request = MPI_REQUEST_NULL;
op = MPI_OP_NULL;
err = MPI_ERRHANDLER_NULL;

group1 = MPI_GROUP_EMPTY;

err = MPI_GRAPH;
err = MPI_CART;

/*
**  A.3 Point-to-Point Communication Bindings
*/
err = MPI_Send(&buffer1, count1, datatype, dest, tag1, comm1);
err = MPI_Recv(&buffer1, count1, datatype, source, tag1, comm1, &status);
err = MPI_Get_count(&status, datatype, &count1);
err = MPI_Bsend(&buffer1, count1, datatype, dest, tag1, comm1);
err = MPI_Ssend(&buffer1, count1, datatype, dest, tag1, comm1);
err = MPI_Rsend(&buffer1, count1, datatype, dest, tag1, comm1);
err = MPI_Buffer_attach( &buffer1, size);
err = MPI_Buffer_detach( &buffer1, &size);
err = MPI_Isend(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Ibsend(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Issend(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Irsend(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Irecv(&buffer1, count1, datatype, source, tag1, comm1, &request);
err = MPI_Wait(&request, &status);
err = MPI_Test(&request, &flag, &status);
err = MPI_Request_free(&request);
err = MPI_Waitany(count1, &request_array[0], &tag1, &status);
err = MPI_Testany(count1, &request_array[0], &tag1, &flag, &status);
err = MPI_Waitall(count1, &request_array[0], &status_array[0]);
err = MPI_Testall(count1, &request_array[0], &flag, &status_array[0]);
err = MPI_Waitsome(count1, &request_array[0], &count2,
         &indicie_array[0], &status_array[0]);
err = MPI_Testsome(count1, &request_array[0], &count2,
         &indicie_array[0], &status_array[0]);
err = MPI_Iprobe(source, tag1, comm1, &flag, &status);
err = MPI_Probe(source, tag1, comm1, &status);
err = MPI_Cancel(&request);
err = MPI_Test_cancelled(&status, &flag);
err = MPI_Send_init(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Bsend_init(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Ssend_init(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Rsend_init(&buffer1, count1, datatype, dest, tag1, comm1, &request);
err = MPI_Recv_init(&buffer1, count1, datatype, source, tag1, comm1, &request);
err = MPI_Start(&request);
err = MPI_Startall(count1, &request_array[0]);
err = MPI_Sendrecv(&buffer1, count1, sendtype, dest, tag1, &buffer2,
                   count2, recvtype, source, tag2, comm1, &status);
err = MPI_Sendrecv_replace(&buffer1, count1, datatype,
             dest, tag1, source, tag2, comm1, &status);
err = MPI_Type_contiguous(count1, oldtype, &newtype);
err = MPI_Type_vector(count1, length, stride, oldtype, &newtype);
err = MPI_Type_hvector(count1, length, astride, oldtype, &newtype);
err = MPI_Type_indexed(count1, &length_array[0],
             &displacement_array[0], oldtype, &newtype);
err = MPI_Type_hindexed(count1, &length_array[0],
              &displacement_aarray[0], oldtype, &newtype);
err = MPI_Type_struct(count1, &length_array[0],
            &displacement_aarray[0], &type_array[0], &newtype);
err = MPI_Address(&location, &address);
err = MPI_Type_extent(datatype, &extent);
err = MPI_Type_size(datatype, &size);
err = MPI_Type_lb(datatype, &displacement);
err = MPI_Type_ub(datatype, &displacement);
err = MPI_Type_commit(&datatype);
err = MPI_Type_free(&datatype);
err = MPI_Get_elements(&status, datatype, &count1);
err = MPI_Pack(&buffer1, count1, datatype, &buffer2,
         size, &position,  comm1);
err = MPI_Unpack(&buffer1, size, &position, &buffer2,
           count2, datatype, comm1);
err = MPI_Pack_size(count1, datatype, comm1, &size);

/*
**  A.4 Collective Communication Bindings
*/
err = MPI_Barrier(comm1);
err = MPI_Bcast(&buffer1, count1, datatype, root, comm1);
err = MPI_Gather(&buffer1, count1, datatype,
           &buffer2, count2, recvtype, root, comm1);
err = MPI_Gatherv(&buffer1, count1, datatype,
        &buffer2, &count2, &displs, recvtype, root, comm1);
err = MPI_Scatter(&buffer1, count1, datatype,
        &buffer2, count2, recvtype, root, comm1);
err = MPI_Scatterv(&buffer1, &count1, &displs,
         datatype, &buffer2, count2, recvtype, root, comm1);
err = MPI_Allgather(&buffer1, count1, datatype,
          &buffer2, count2, recvtype, comm1);
err = MPI_Allgatherv(&buffer1, count1, datatype,
           &buffer2, &count2, &displs, recvtype, comm1);
err = MPI_Alltoall(&buffer1, count1, datatype,
         &buffer2, count2, recvtype, comm1);
err = MPI_Alltoallv(&buffer1, &count1, &displs1,
          datatype, &buffer2, &count2,
          &displs2, recvtype, comm1);
err = MPI_Reduce(&buffer1, &buffer2, count1, datatype, op, root, comm1);
err = MPI_Op_create((MPI_User_function *)&userfunction, commute, &op);
err = MPI_Op_free(&op);
err = MPI_Allreduce(&buffer1, &buffer2, count1, datatype, op, comm1);
err = MPI_Reduce_scatter(&buffer1, &buffer2, &count2,
               datatype, op, comm1);
err = MPI_Scan(&buffer1, &buffer2, count1, datatype, op, comm1);

/*
**  A.5 Groups, Contexts and Communicators Bindings
*/
err = MPI_Group_size(group1, &size);
err = MPI_Group_rank(group1, &rank1);
err = MPI_Group_translate_ranks (group1, count1, &rank1, group2, &rank2);
err = MPI_Group_compare(group1, group2, &result);
err = MPI_Comm_group(comm1, &group1);
err = MPI_Group_union(group1, group2, &newgroup);
err = MPI_Group_intersection(group1, group2, &newgroup);
err = MPI_Group_difference(group1, group2, &newgroup);
err = MPI_Group_incl(group1, count1, &rank_array[0], &newgroup);
err = MPI_Group_excl(group1, count1, &rank_array[0], &newgroup);
err = MPI_Group_range_incl(group1, count1, &ranges[0], &newgroup);
err = MPI_Group_range_excl(group1, count1, &ranges[0], &newgroup);
err = MPI_Group_free(&group1);
err = MPI_Comm_size(comm1, &size);
err = MPI_Comm_rank(comm1, &rank1);
err = MPI_Comm_compare(comm1, comm2, &result);
err = MPI_Comm_dup(comm1, &newcomm);
err = MPI_Comm_create(comm1, group1, &newcomm);
err = MPI_Comm_split(comm1, color, keyval, &newcomm);
err = MPI_Comm_free(&comm1);
err = MPI_Comm_test_inter(comm1, &flag);
err = MPI_Comm_remote_size(comm1, &size);
err = MPI_Comm_remote_group(comm1, &group1);
err = MPI_Intercomm_create(comm1, leader1, comm2, leader2, tag1, &newcomm);
err = MPI_Intercomm_merge(comm1, high, &newcomm);
err = MPI_Keyval_create((MPI_Copy_function *)&copyfunction,
                        (MPI_Delete_function *)&deletefunction,
                        &keyval, &state);
err = MPI_Keyval_free(&keyval);
err = MPI_Attr_put(comm1, keyval, &attribute_val);
err = MPI_Attr_get(comm1, keyval, &attribute_val, &flag);
err = MPI_Attr_delete(comm1, keyval);

/*
**  A.6 Process Topologies Bindings
*/
err = MPI_Cart_create(comm1, ndims, &dims, &periods, reorder, &comm2);
err = MPI_Dims_create(nnodes, ndims, &dims);
err = MPI_Graph_create(comm1, nnodes, &index_array[0], &edge_array[0],
             reorder, &comm2);
err = MPI_Topo_test(comm1, &result);
err = MPI_Graphdims_get(comm1, &nnodes, &nedges);
err = MPI_Graph_get(comm1, maxindex, maxedges, &index_array[0], &edge_array[0]);
err = MPI_Cartdim_get(comm1, &ndims);
err = MPI_Cart_get(comm1, maxdims, &dims, &periods, &coords);
err = MPI_Cart_rank(comm1, &coords, &rank1);
err = MPI_Cart_coords(comm1, rank1, maxdims, &coords);
err = MPI_Graph_neighbors_count(comm1, rank1, &nneighbors);
err = MPI_Graph_neighbors(comm1, rank1, maxneighbors, &neighbors);
err = MPI_Cart_shift(comm1, direction, displs, &rank1, &rank2);
err = MPI_Cart_sub(comm1, &dims, &newcomm);
err = MPI_Cart_map(comm1, ndims, &dims, &periods, &rank1);
err = MPI_Graph_map(comm1, nnodes, &index_array[0], &edge_array[0], &rank1);

/*
**  A.7 Environmental Inquiry Bindings
*/
err = MPI_Get_processor_name(&name[0], &result);
err = MPI_Errhandler_create((MPI_Handler_function *)&handlerfunction,
                          &errhandler);
err = MPI_Errhandler_set(comm1, errhandler);
err = MPI_Errhandler_get(comm1, &errhandler);
err = MPI_Errhandler_free(&errhandler);
err = MPI_Error_string(errorcode, &string[0], &result);
err = MPI_Error_class(errorcode, &errorclass);
time = MPI_Wtime();
time = MPI_Wtick();
err = MPI_Initialized(&flag);
err = MPI_Abort(comm1, errorcode);

/*
**  A.8 Profiling Bindings
*/
err = MPI_Pcontrol(level, errorcode);

}
else
    pass++;

/* report overall results  */
MPITEST_report(pass, fail, 0, testname);

err = MPI_Finalize();
return fail;
}
