/*
   bit_matrix_fns.h
*/

/* $Id: bit_matrix_fns.h,v 1.2 1997/05/06 22:02:30 thc Exp $
 * $Log: bit_matrix_fns.h,v $
 * Revision 1.2  1997/05/06 22:02:30  thc
 * Added copyright notice.
 *
 * Revision 1.1  1997/04/14 15:49:57  thc
 * Initial revision
 *
 */

/*
 * Copyright (C) 1997, Thomas H. Cormen, thc@cs.dartmouth.edu
 *
 * This software may be freely copied, modified, and redistributed,
 * provided that this copyright notice is preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this
 * software, and it is provided solely "as is".  Bug reports or fixes
 * may be sent to the author, who may or may not act on them as he
 * desires.
 *
 * Rights are granted to use this software in any non-commercial
 * enterprise.  For commercial rights to this software, please contact
 * the author.
 */

#ifndef _BIT_MATRIX_FNS_H
#define _BIT_MATRIX_FNS_H

#include "bit_matrix_types.h"

bit_matrix identity_matrix(bit_matrix A, int n);

int is_identity_matrix(bit_matrix A, int n);

bit_matrix bit_matrix_multiply(bit_matrix C, bit_matrix A, bit_matrix B,
			       int n);

matrix_column bit_matrix_vector_multiply(bit_matrix A, matrix_column x, int n);

int invert_bit_matrix(bit_matrix A_inv, bit_matrix A, int n);

bit_matrix allocate_bit_matrix(int n);

bit_matrix copy_bit_matrix(bit_matrix target, bit_matrix source, int n);

bit_matrix dup_bit_matrix(bit_matrix A, int n);

void free_bit_matrix(bit_matrix A);

bit_matrix extract_bit_submatrix(bit_matrix target, bit_matrix source,
				 int start_row, int start_col,
				 int rows, int cols);

bit_matrix remove_bit_matrix_rows(bit_matrix target, bit_matrix source,
				  int n, int start_row, int rows);

int find_bit_matrix_basis(matrix_column *basis, bit_matrix A,
			  int rows, int cols);

matrix_column find_dependencies(bit_matrix dep, bit_matrix A, int m, int n);

void print_bit_matrix(bit_matrix A, int m, int n, char *name);

#endif
