# include <sys/types.h>
# include <pwd.h>
# include <stdio.h>
# include <sysexits.h>
# include <ctype.h>
# include <sys/file.h>

# define TRUE           1
# define FALSE          0

# define MAXLENGTH          125      /* maximum size of a line or address */
# define MAX_NETLIB_LENGTH  1000     /* maximum size of a entry in the netlib database */

extern FILE *fp_debug;
extern FILE *fp_store;
extern FILE *fp_message;
extern FILE *fp_netlib;


whois_netlib ( )
  {
    int   position = 0;   
    int   found_first_name_in_file = FALSE;
    int   found_last_name_in_file = FALSE;
    char  last_name_database[MAXLENGTH];
    char  first_name_database[MAXLENGTH];           
    char  line[MAX_NETLIB_LENGTH];           
 
    char  last_name[MAXLENGTH];           int found_last_name = FALSE;
    char  first_name[MAXLENGTH];          int found_first_name = FALSE;
    char  middle_name[MAXLENGTH];         int found_middle_name = FALSE;
    char  college_university[MAXLENGTH];  int found_college_university = FALSE;
    char  company[MAXLENGTH];             int found_company = FALSE;
    char  office_address[MAXLENGTH];      int found_office_address = FALSE;
    char  city_state_zip[MAXLENGTH];      int found_city_state_zip = FALSE;
    char  office_phone[MAXLENGTH];        int found_office_phone = FALSE;
    char  research[MAXLENGTH];            int found_research = FALSE;
    char  home_address[MAXLENGTH];        int found_home_address = FALSE;
    char  home_phone[MAXLENGTH];          int found_home_phone = FALSE;
    char  fax[MAXLENGTH];                 int found_fax = FALSE;
    char  e_mail_address[MAXLENGTH];      int found_e_mail_address = FALSE;
    char  other[MAXLENGTH];               int found_other = FALSE;


    parse_stored_message (last_name,          &found_last_name,
                          first_name,         &found_first_name,
                          middle_name,        &found_middle_name,
                          college_university, &found_college_university,
                          company,            &found_company,
                          office_address,     &found_office_address,
                          city_state_zip,     &found_city_state_zip,
                          office_phone,       &found_office_phone,
                          research,           &found_research,
                          home_address,       &found_home_address,
                          home_phone,         &found_home_phone,
                          fax,                &found_fax,
                          e_mail_address,     &found_e_mail_address,
                          other,              &found_other);


    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
   
    if (found_first_name || found_last_name) {
       fp_netlib = fopen ("/usr/cfs1/nanet/netlib.database", "r");

       while (fgets (line, sizeof line, fp_netlib) != NULL)
         {
            position = 0;
            get_next_field (line, last_name_database, &position);

            if (found_last_name && found_first_name) 
              {
                if (my_strcasecmp (last_name_database, last_name) == 0)  
                  {
                    get_next_field (line, first_name_database, &position);
                    if (my_strcasecmp (last_name_database, last_name) == 0) 
                      {
                        found_first_name_in_file = TRUE;
                        found_last_name_in_file = TRUE;
                        fprintf (fp_debug, "Found first and last names \n");
                        print_info_to_message_file (line); 
                      }
                   }
              }

            else if (found_last_name) 
              {
                 if (my_strcasecmp (last_name_database, last_name) == 0)  
                   {
                     found_last_name_in_file = TRUE;
                     fprintf (fp_debug, "Found last name \n");
                     print_info_to_message_file (line); 
                   }
              }

            else         /* Found just first name */
              {
                 get_next_field (line, first_name_database, &position);
                 if (my_strcasecmp (first_name_database, first_name) == 0)  
                   {
                     found_first_name_in_file = TRUE;
                     fprintf (fp_debug, "Found first name \n");
                     print_info_to_message_file (line); 
                   }
               }
      

        }   /* end while */

        if (found_last_name) 
          {
            if (found_last_name_in_file == FALSE)
              {
                fprintf (fp_message, "Did not find last name in file \n");
              }
          }

        if (found_first_name) 
          {
            if (found_first_name_in_file == FALSE)
              {
                fprintf (fp_message, "Did not find first name in file \n");
              }
           } 


        fclose(fp_netlib);
      }
    else    /* Did not find first or last names */
      {
         fprintf (fp_debug, "Did not find first or last names \n");
         fprintf (fp_message, "Did not find first or last names \n");
       }   
    fclose(fp_message);

  }



add_to_netlib_database ( )
  {
    int   position = 0;   
    int   found_first_name_in_file = FALSE;
    int   found_last_name_in_file = FALSE;
    char  last_name_database[MAXLENGTH];
    char  first_name_database[MAXLENGTH];           
    char  line[MAX_NETLIB_LENGTH];           
 
    char  last_name[MAXLENGTH];           int found_last_name = FALSE;
    char  first_name[MAXLENGTH];          int found_first_name = FALSE;
    char  middle_name[MAXLENGTH];         int found_middle_name = FALSE;
    char  college_university[MAXLENGTH];  int found_college_university = FALSE;
    char  company[MAXLENGTH];             int found_company = FALSE;
    char  office_address[MAXLENGTH];      int found_office_address = FALSE;
    char  city_state_zip[MAXLENGTH];      int found_city_state_zip = FALSE;
    char  office_phone[MAXLENGTH];        int found_office_phone = FALSE;
    char  research[MAXLENGTH];            int found_research = FALSE;
    char  home_address[MAXLENGTH];        int found_home_address = FALSE;
    char  home_phone[MAXLENGTH];          int found_home_phone = FALSE;
    char  fax[MAXLENGTH];                 int found_fax = FALSE;
    char  e_mail_address[MAXLENGTH];      int found_e_mail_address = FALSE;
    char  other[MAXLENGTH];               int found_other = FALSE;


    parse_stored_message (last_name,          &found_last_name,
                          first_name,         &found_first_name,
                          middle_name,        &found_middle_name,
                          college_university, &found_college_university,
                          company,            &found_company,
                          office_address,     &found_office_address,
                          city_state_zip,     &found_city_state_zip,
                          office_phone,       &found_office_phone,
                          research,           &found_research,
                          home_address,       &found_home_address,
                          home_phone,         &found_home_phone,
                          fax,                &found_fax,
                          e_mail_address,     &found_e_mail_address,
                          other,              &found_other);


    fp_message = fopen("/usr/cfs1/nanet/message.txt", "w");
    if (found_last_name && found_first_name) 
      { 
        if (name_is_unique (first_name, middle_name, last_name))
          {

            fp_netlib = fopen("/usr/cfs1/nanet/netlib.database", "a");
            fprintf (fp_netlib, "%s
", last_name);
            fprintf (fp_netlib, "%s
", first_name);
            fprintf (fp_netlib, "%s
", middle_name); 
            fprintf (fp_netlib, "%s
", college_university); 
            fprintf (fp_netlib, "%s
", company); 
            fprintf (fp_netlib, "%s
", office_address);
            fprintf (fp_netlib, "%s
", city_state_zip);
            fprintf (fp_netlib, "%s
", office_phone);
            fprintf (fp_netlib, "%s
", research);
            fprintf (fp_netlib, "%s
", home_address);
            fprintf (fp_netlib, "%s
", home_phone);  
            fprintf (fp_netlib, "%s
", fax);  
            fprintf (fp_netlib, "%s
", e_mail_address);  
            fprintf (fp_netlib, "%s
\n", other);  

            fclose (fp_netlib); 
            system("sort -o /usr/cfs1/nanet/netlib.database /usr/cfs1/nanet/netlib.database"); 

            fprintf(fp_message, "You have been successfully added to the Netlib database\n");
            fprintf(fp_message, "Last name and first name found");
         }
       else
         {
            fprintf (fp_debug, "Error in join - name is not unique. \n");
            fprintf (fp_message, "Error in join - name is not unique. \n");
            fprintf (fp_message, "The combination of lastname, firstname, m \n");
         } 
      }
    else
      {   
        fprintf(fp_message, "You have NOT been successfully added to the Netlib database\n");
        fprintf(fp_message, "Last name or first name was not found");
      }
    fclose(fp_message);

  }





change_netlib_data_base (last_name, first_name, middle_name, office_phone,
                         office_address, office_fax, home_address, home_phone)
char  last_name[MAXLENGTH],    first_name[MAXLENGTH];
char  middle_name[MAXLENGTH]; 
char  office_phone[MAXLENGTH],  office_address[MAXLENGTH];
char  office_fax[MAXLENGTH],    home_address[MAXLENGTH];
char  home_phone[MAXLENGTH];

  {
 
/*************************************** 

   parse_stored_message ( );


   if (address_was_changed == TRUE) {
       fp_temp   = fopen("/usr/cfs1/nanet/temp.netlib_update", "r");
       fp_master = fopen("/usr/cfs1/nanet/netlib.database", "w");
       while (fgets(line, sizeof line, fp_temp) != NULL) {
       }
       fclose (fp_temp);
       fclose (fp_netlib);
       fprintf(fp_debug, "returning TRUE\n");
       return (TRUE);
    }
    else
      {
         WHO_TO = 1;
         fprintf(fp_debug, "returning FALSE\n");
         return(FALSE);
      }

****************************************/


  }

name_is_unique (first_name, middle_name, last_name)
char  first_name[MAXLENGTH],   middle_name[MAXLENGTH], last_name[MAXLENGTH];
  {
    int  position;
    char line[MAXLENGTH];
    char temp_word[MAXLENGTH];
    int  found = FALSE;

    fp_netlib = fopen("/usr/cfs1/nanet/netlib.database", "r");

    while (fgets (line, sizeof line, fp_netlib) != NULL)
      {
        position = 0;
        get_word (line, temp_word, &position);
        if (my_strcasecmp (temp_word, last_name) == 0)
          {
            remove_spaces (line, &position);
            get_word (line, temp_word, &position);
            if (my_strcasecmp (temp_word, first_name) == 0)
              {
                remove_spaces (line, &position);
                get_word (line, temp_word, &position);
                if (my_strcasecmp (temp_word, middle_name) == 0)
                  {
                    found = TRUE;
                    fclose (fp_netlib);
                    return (FALSE); 
                  }

              }
          }

      }
    fclose (fp_netlib);
    if (found == FALSE)
      return (TRUE);

  }



print_info_to_message_file (line)
char  line[MAX_NETLIB_LENGTH];
  {
    int  position = 0;
    char temp_word[MAXLENGTH];

    fprintf (fp_message, "\n");
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "         Last name - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "        First name - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "       Middle name - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "College/University - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "           Company - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "    Office address - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "    City/State/Zip - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "      Office phone - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "          Research - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "      Home address - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "        Home phone - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "               Fax - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "    E-mail Address - %s\n", temp_word);
    get_next_field (line, temp_word, &position);
    fprintf (fp_message, "             Other - %s\n", temp_word);
    fprintf (fp_message, "\n");

  }



parse_stored_message 
  (last_name,          found_last_name,
   first_name,         found_first_name,
   middle_name,        found_middle_name,
   college_university, found_college_university,
   company,            found_company,
   office_address,     found_office_address,
   city_state_zip,     found_city_state_zip,
   office_phone,       found_office_phone,
   research,           found_research,
   home_address,       found_home_address,
   home_phone,         found_home_phone,
   fax,                found_fax,
   e_mail_address,     found_e_mail_address,
   other,              found_other)

   char  last_name[MAXLENGTH];           int *found_last_name;
   char  first_name[MAXLENGTH];          int *found_first_name;
   char  middle_name[MAXLENGTH];         int *found_middle_name;
   char  college_university[MAXLENGTH];  int *found_college_university;
   char  company[MAXLENGTH];             int *found_company;
   char  office_address[MAXLENGTH];      int *found_office_address;
   char  city_state_zip[MAXLENGTH];      int *found_city_state_zip;
   char  office_phone[MAXLENGTH];        int *found_office_phone;
   char  research[MAXLENGTH];            int *found_research;
   char  home_address[MAXLENGTH];        int *found_home_address;
   char  home_phone[MAXLENGTH];          int *found_home_phone;
   char  fax[MAXLENGTH];                 int *found_fax;
   char  e_mail_address[MAXLENGTH];      int *found_e_mail_address;
   char  other[MAXLENGTH];               int *found_other;


  {
    int position;
    char  line[MAXLENGTH];               
    char  temp_word[MAXLENGTH];   

    fp_store = fopen("/usr/cfs1/nanet/store", "r");
    while (fgets(line, sizeof line, fp_store) != NULL)
      {
         position = 0;
         remove_spaces(line, &position);
         get_word(line, temp_word, &position);
         if (my_strcasecmp(temp_word, "Last_name:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, last_name);
            fprintf(fp_debug, "Last name requested = %s \n", last_name);
            *found_last_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "First_name:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, first_name);
            fprintf(fp_debug, "First name requested = %s \n", first_name);
            *found_first_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Middle_name:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, middle_name);
            fprintf(fp_debug, "Middle name = %s \n", middle_name);
            *found_middle_name = TRUE;
         }
         else if (my_strcasecmp(temp_word, "College_University:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, college_university);
            fprintf(fp_debug, "College / University = %s \n", college_university);
            *found_college_university = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Company:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, company);
            fprintf(fp_debug, "Company = %s \n", company);
            *found_company = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Office_address:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, office_address);
            fprintf(fp_debug, "Office address = %s \n", office_address);
            *found_office_address = TRUE;
         }
         else if (my_strcasecmp(temp_word, "City_State_Zip:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, city_state_zip);
            fprintf(fp_debug, "City / State / Zip = %s \n", city_state_zip);
            *found_city_state_zip = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Office_Phone:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, office_phone);
            fprintf(fp_debug, "Office phone = %s \n", office_phone);
            *found_office_phone = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Research:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, research);
            fprintf(fp_debug, "Research = %s \n", research);
            *found_research = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Home_address:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, home_address);
            fprintf(fp_debug, "Home Address = %s \n", home_address);
            *found_home_address = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Home_phone:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, home_phone);
            fprintf(fp_debug, "Home Phone = %s \n", home_phone);
            *found_home_phone = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Fax:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, fax);
            fprintf(fp_debug, "Fax = %s \n", fax);
            *found_fax = TRUE;
         }
         else if (my_strcasecmp(temp_word, "E_mail_address:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, e_mail_address);
            fprintf(fp_debug, "E mail address = %s \n", e_mail_address);
            *found_e_mail_address = TRUE;
         }
         else if (my_strcasecmp(temp_word, "Other:") == 0) {
            remove_spaces(line, &position);
            copy_line (line, position, other);
            fprintf(fp_debug, "Other = %s \n", other);
            *found_other = TRUE;
         }
         else
          {
          }
      } 

      fclose(fp_store);

  }
  

/* The following function is used to get values which  */
/* may contain spaces.                                 */

copy_line_with_spaces (line, position, word)
char  line[MAXLENGTH];
int   position;
char  word[MAXLENGTH];
  {
     int count = 0;

     while (line[position] != '\n')
       {
          word[count] = line[position];
          position++;
          count++;
       }
     word[count] = '\0';
  }



get_next_field (buffer, word, position)
  char  buffer[MAX_NETLIB_LENGTH];
  char  word[MAXLENGTH];
  int   *position;
  {
    int count;

    count = 0;
    while (buffer[*position] != '
'  &&  buffer[*position] != '\n')
      {
        word[count] = buffer[*position];
        *position = *position + 1;
        count = count + 1;
      }
    *position = *position + 1;    /* increment past next control M */
    word[count] = '\0';
  }

