#include "BSprivate.h"

/*+ BSx_color - Color a graph

	Input Parameters: 
.   A - The graph (matrix) to color
.   procinfo - the usual processor info
.   method - the method used for the local coloring

	Output Parameters: 
.   local_color - The coloring
.   max_gcolors - the number of colors used in the global coloring

	Notes:
    We use the Jones/Plassmann algorithm for the global coloring
    and either IDO/SDO for the local coloring
+*/
void BSx_color(local_color,A,procinfo,max_gcolors,method)
int	*local_color;
BSspmat *A;
BSprocinfo *procinfo;
int *max_gcolors;
int method;
{
	/* matrix variables */
	int	num_cols;
	BSsprow	**local_rows;
	
	/* process control variables */
	int size;
	int type;
	int from;

	/* variables that we really care about */
	int i, j;
	int	my_num_nz;						/* the # of nonzeros I have */
	int	**global_color;					/* global colors */
	int	*row_ptr;
	BSsprow	*t_node;
	int	*int_msg;
	int	*local_ptr;
	int	*global_ptr;
	int	*search_ptr;
	int	*color_template;
	int	*local_queue;
	int	*msg_queue;
	int	*msg_buffer;
	int	*ido_queue_ptr;
	int	*ido_degree;
	int	*ido_deg_ptr;
	int	num_colored;
	int	max_deg;
	int	n_msg_queue;
	int	n_local_queue;
	int	t_color, l_vtx;
	int vtx, vtx_color, vtx_size, msg_ptr;
	int msg_buffer_size;
	int p1, p2, p3, r1, r2, v1, v2;
	int n_searchs, search_size;
	int color_msg_received, color_msg_size;
	int owner, work, temp;
	BSmsg_list	*msg_list = NULL;

	MLOG_ELM(procinfo->procset);

	num_cols = A->num_rows;
	local_rows = A->rows;

	MY_MALLOC(local_ptr,(int *),sizeof(int)*num_cols,1);
	MY_MALLOC(global_ptr,(int *),sizeof(int)*num_cols,2);
	MY_MALLOC(search_ptr,(int *),sizeof(int)*num_cols,3);
	MY_MALLOC(local_queue,(int *),sizeof(int)*num_cols,4);
	MY_MALLOC(msg_queue,(int *),sizeof(int)*num_cols,5);
	MY_MALLOC(ido_queue_ptr,(int *),sizeof(int)*num_cols,6);
	MY_MALLOC(ido_degree,(int *),sizeof(int)*num_cols,7);

	/* Determine max_deg */
	my_num_nz = 0;
	max_deg = 0;
	for (i=0;i<num_cols;i++) {
		t_node = local_rows[i];
		p1 = t_node->length;
		if (max_deg < p1) max_deg = p1;
		/* my_num_nz += p1; */
	}

	GIMAX(&max_deg,1,&work,procinfo->procset); CHKERR(0);
	MY_MALLOC(color_template,(int *),sizeof(int)*(max_deg+1),7);
	MY_MALLOC(ido_deg_ptr,(int *),sizeof(int)*(max_deg+1),8);

	for (i=0;i<num_cols;i++) {

		t_node = local_rows[i];
		row_ptr = t_node->col;
		p1 = 0;
		p2 = t_node->length;

		/* Separate local variables from global variables */
		/* color_template used for temp storage of global variables */
		for (j=t_node->length-1; j>=0; j--) {
			v2 = row_ptr[j];
			(*A->map->fglobal2proc)
				(1,&v2,&owner,procinfo,A->map); CHKERR(0);
			if (owner == procinfo->my_id) {
				p2--;
				row_ptr[p2] = v2;
			}
			else {
				color_template[p1] = v2;
				p1++;
			}
		}
		local_ptr[i] = p2;

		p1 = 0;
		/* get global row number of row i */
		(*A->map->flocal2global)(1,&i,&v1,procinfo,A->map); 
		CHKERR(0);
		r1 = BSmy_rand(v1);

		/* Separate global variables by random numbers */
		/* ido_deg_ptr used for temp storage of random numbers */
		for (j=0; j<local_ptr[i]; j++) {
			v2 = color_template[j];
			r2 = BSmy_rand(v2); CHKERR(0);
			if (r2 > r1) {
				row_ptr[p1] = v2;
				ido_deg_ptr[p1] = r2;
				p1++;
			}
			else if((r2 == r1) && (v2 > v1)) {
				row_ptr[p1] = v2;
				ido_deg_ptr[p1] = r2;
				p1++;
			}
			else {
				p2--;
				row_ptr[p2] = v2;
			}
		}
		global_ptr[i] = p2;

		/* Sort global variables by random number */
		BSheap_sort1(global_ptr[i],ido_deg_ptr,row_ptr); CHKERR(0);
	}

	msg_buffer_size = 1000;
	/* msg_buffer_size = 10*(max_deg+4); */
	MY_MALLOC(msg_buffer,(int *),sizeof(int)*msg_buffer_size,9);

	/* Initialize local_queue and msg_queue */
	/* Initialize local_color, ido_queue_ptr, ido_degree */
	/* Set search_ptr */
	n_local_queue = 0;
	n_msg_queue = 0;
	for (i=0; i<num_cols; i++) {
		local_color[i] = NO_COLOR;
		ido_queue_ptr[i] = 0;
		ido_degree[i] = 0;
		search_ptr[i] = 0;
		if (local_ptr[i] == 0) {
			local_queue[n_local_queue] = i;
			n_local_queue++;
		}
		else if (global_ptr[i] == 0) {
			msg_queue[n_msg_queue] = i;
			n_msg_queue++;
		}
	}

	/* Initialize color_template */
	for (i=0; i<max_deg+1; i++) {
		color_template[i] = NO_COLOR;
	}

	/* Set up global_color arrays */
	MY_MALLOC(global_color,(int **),sizeof(int *)*num_cols,10);
	for (i=0; i<num_cols; i++) {
		MY_MALLOC(global_color[i],(int *),sizeof(int)*global_ptr[i],11);
		for (j=0; j<global_ptr[i]; j++) 
			global_color[i][j] = NO_COLOR;
	}

	num_colored = 0;
	if (n_msg_queue != 0) {
		/* Color stuff in msg_queue */
		if (method == SDO)
		{
		BSsdo_color(msg_queue,n_msg_queue,A,local_color,
			global_color,local_ptr,global_ptr,color_template,
			ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
		}
		else
		{
		BSido_color(msg_queue,n_msg_queue,A,local_color,
			global_color,local_ptr,global_ptr,color_template,
			ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
		}

		/* Send stuff in msg_queue */
		BSpack_n_send(msg_list,n_msg_queue,&msg_queue[0],A,
			procinfo,&local_color[0],&local_ptr[0],&global_ptr[0],
			&msg_buffer[0],msg_buffer_size,COLOR_MSG); CHKERR(0);

		num_colored = n_msg_queue;
		n_msg_queue = 0;
	}

	/* Generate some statistics */
	/*
	n_searchs = 0;
	search_size = 0;
	color_msg_received = 0;
	color_msg_size = 0;
	*/

	/* Main global coloring loop */
	while (num_colored + n_local_queue < num_cols) {
		type = COLOR_MSG;
		RECVSYNCUNSZ(type,int_msg,size,MSG_INT); CHKERR(0);
		from = RECVFROM();
		size = RECVLEN();
		CHECK_SEND_LIST(msg_list);
		/* color_msg_received++; */
		/* color_msg_size += size; */
		msg_ptr = 1;
		/* For each vtx in message */
		for (i=0;i<int_msg[0];i++) {
			vtx = int_msg[msg_ptr];
			vtx_color = int_msg[msg_ptr+1];
			vtx_size = int_msg[msg_ptr+2];
			j = msg_ptr + 3;
			msg_ptr = j + vtx_size;
			/* For each l_vtx adjacent to vtx */
			while (j < msg_ptr) {
				(*A->map->fglobal2proc)
					(1,&(int_msg[j]),&owner,procinfo,A->map);CHKERR(0);
				if (owner != procinfo->my_id) {
					MY_SETERRC(COLOR1_ERROR,"Msg not local");
				}
				/* get local index of global index */
				(*A->map->fglobal2local)
					(1,&(int_msg[j]),&l_vtx,procinfo,A->map);CHKERR(0);
				j++;
				t_node = local_rows[l_vtx];
				row_ptr = t_node->col;
				p1 = search_ptr[l_vtx];
				p2 = p1;
				p3 = global_ptr[l_vtx];
				while (row_ptr[p2] != vtx) {
					p2++;
					if(p2 >= p3) {
						MY_SETERRC(COLOR2_ERROR,"Ptr > Global Ptr");
					}
				}
				/* n_searchs++; */
				/* search_size += p2-p1+1; */
				if (p1 != p2) {
					v1 = row_ptr[p1];
					row_ptr[p1] = row_ptr[p2];
					row_ptr[p2] = v1;
				}
				global_color[l_vtx][p1] = vtx_color;
				search_ptr[l_vtx]++;
				if (search_ptr[l_vtx] == local_ptr[l_vtx]) {
					local_queue[n_local_queue] = l_vtx;
					n_local_queue++;
				}
				else if (search_ptr[l_vtx] == global_ptr[l_vtx]) {
					msg_queue[n_msg_queue] = l_vtx;
					n_msg_queue++;
				}
			}
		}
		MSGFREERECV(int_msg);CHKERR(0);

		/* color guys in msg_queue */
		if (n_msg_queue != 0) {
			if (method == SDO)
			{
			BSsdo_color(msg_queue,n_msg_queue,A,local_color,
				global_color,local_ptr,global_ptr,color_template,
				ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
			}
			else
			{
			BSido_color(msg_queue,n_msg_queue,A,local_color,
				global_color,local_ptr,global_ptr,color_template,
				ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
			}
			num_colored += n_msg_queue;
		}

		/* Send stuff in msg_queue */
		if (n_msg_queue != 0) {
			BSpack_n_send(msg_list,n_msg_queue,&msg_queue[0],A,
				procinfo,&local_color[0],&local_ptr[0],&global_ptr[0],
				&msg_buffer[0],msg_buffer_size,COLOR_MSG); CHKERR(0);
			n_msg_queue = 0;
		}
	}

	/* Color stuff in local_queue */

	/* Calculate maximum global color */
	
	*max_gcolors = NO_COLOR;
	for (i=0; i < num_cols; i++)
	{
		temp = local_color[i];
		if (temp > *max_gcolors)
			*max_gcolors = temp;
	}
	GIMAX(max_gcolors,1,&work,procinfo->procset); CHKERR(0);
	(*max_gcolors)++;

	if (n_local_queue > 0)
	{
		if (method == SDO)
		{
		BSsdo_color(local_queue,n_local_queue,A,local_color,
			global_color,local_ptr,global_ptr,color_template,
			ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
		}
		else
		{
		BSido_color(local_queue,n_local_queue,A,local_color,
			global_color,local_ptr,global_ptr,color_template,
			ido_degree,ido_queue_ptr,ido_deg_ptr,procinfo); CHKERR(0);
		}
	}

	/* Resort row_ptr */
	for (i=0;i<num_cols;i++) {
		t_node = local_rows[i];
		row_ptr = t_node->col;
		v1 = t_node->length;
		BSheap_sort0(global_ptr[i],row_ptr); CHKERR(0);
		p1 = 0;
		p2 = global_ptr[i];
		for (j=0; j<local_ptr[i]; j++) {
			if (p1 >= global_ptr[i]) {
				color_template[j] = row_ptr[p2];
				p2++;
			}
			else if (p2 >= local_ptr[i]) {
				color_template[j] = row_ptr[p1];
				p1++;
			}
			else {
				if (row_ptr[p1] < row_ptr[p2]) {
					color_template[j] = row_ptr[p1];
					p1++;
				}
				else {
					color_template[j] = row_ptr[p2];
					p2++;
				}
			}
		}
		p1 = 0;
		p2 = local_ptr[i];
		for (j=0; j<v1; j++) {
			if (p1 >= local_ptr[i]) {
				row_ptr[j] = row_ptr[p2];
				p2++;
			}
			else if (p2 >= v1) {
				row_ptr[j] = color_template[p1];
				p1++;
			}
			else {
				if (color_template[p1] < row_ptr[p2]) {
					row_ptr[j] = color_template[p1];
					p1++;
				}
				else {
					row_ptr[j] = row_ptr[p2];
					p2++;
				}
			}
		}
	}
	FINISH_SEND_LIST(msg_list);

	/* now free up the work vectors that we have allocated */
	MY_FREE(local_ptr);
	MY_FREE(global_ptr);
	MY_FREE(search_ptr);
	MY_FREE(color_template);
	MY_FREE(msg_buffer);
	MY_FREE(local_queue);
	MY_FREE(ido_queue_ptr);
	MY_FREE(ido_degree);
	MY_FREE(ido_deg_ptr);
	MY_FREE(msg_queue);
	for (i=0;i<num_cols;i++) MY_FREE(global_color[i]);
	MY_FREE(global_color);

	MLOG_IT(COLOR);
}

