#include	"BSprivate.h"

/*+ BSsort_rows - Sort the rows of A by column number

    Input Parameters:
.   A - a sparse matrix

    Output Parameters:
.   A - a sparse matrix with rows in sorted order

    Returns:
    void

 +*/
void BSsort_rows(A,perm,distr,max_row_len)
BSspmat *A;
BSpermutation	*perm;
BSdistribution	*distr;
int	max_row_len;
{
	int	i, j, k;
	int	ind, *colptr;
	int	count;
	BSpermutation	*iperm, *tperm;
	FLOAT	*dwork;
	BSsprow	*row;
	FLOAT	*nzptr;
	double	t1, t2;

	iperm = BSalloc_permutation(A->num_rows); CHKERR(0);
	BSperm2iperm(perm,iperm); CHKERR(0);
	MY_MALLOC(dwork,(double *),sizeof(double)*max_row_len,1);
	tperm = BSalloc_permutation(max_row_len); CHKERR(0);
	count = 0;
	for (i=0;i<distr->max+1;i++) {
		ind = iperm->perm[count];
		row = A->rows[ind];
		BSreset_permutation(row->length,tperm); CHKERR(0);
		colptr = row->col;
		for (j=0;j<row->length;j++) tperm->perm[j] = j;
		BSheap_sort1(row->length,colptr,tperm->perm); CHKERR(0);
		for (j=0;j<distr->distribution[i];j++) {
			ind = iperm->perm[count];
			row = A->rows[ind];
			nzptr = row->nz;
			BSiperm_dvec(nzptr,dwork,tperm); CHKERR(0);
			for (k=0;k<row->length;k++) {
				nzptr[k] = dwork[k];
			}
			count++;
		}
	}
	BSfree_permutation(iperm); CHKERR(0);
	BSfree_permutation(tperm); CHKERR(0);
	MY_FREE(dwork);
}
