#include "BSprivate.h"

/*@ BSsetup_factor - Set up the communication for factorization

    Input Parameters:
.   A - a sparse matrix
.   procinfo - the usual processor stuff

    Returns:
    the communication structure for factorization

 @*/
BScomm *BSsetup_factor(A,procinfo)
BSpar_mat *A;
BSprocinfo *procinfo;
{
	BMcomp_msg *to_msg, *from_msg;
	BScomm *comm_ptr;
	BMphase *phase_ptr;
	BMmsg *msg;
	int	i;
	int	cl_ind, in_ind;
	int	count;
	int	*setup_data, *user_data;
	BScl_2_inode *clique2inode;
	BSnumbering *color2clique;
	BSinode *inodes;

	/* initialize communication structures */
	to_msg = BMcomp_init(COMP_MSG_BASE); CHKERRN(0);
	from_msg = BMcomp_init(COMP_MSG_BASE); CHKERRN(0);

	/* initialize variables for ease of use */
	color2clique = A->color2clique;
	clique2inode = A->clique2inode;
	inodes = A->inodes->list;

	/* now go through and figure out everyone that we need stuff from */
	/* do it by color, where each color is a phase */
	for (i=0;i<color2clique->length-1;i++) {
		for (cl_ind = color2clique->numbers[i];
			cl_ind < color2clique->numbers[i+1];cl_ind++) {
			/* figure out the message size and destination */
			if (clique2inode->proc[cl_ind] != procinfo->my_id) {
				for (in_ind=clique2inode->inode_index[cl_ind];
					in_ind<clique2inode->inode_index[cl_ind+1];in_ind++) {
					if (inodes[in_ind].length > 0) {
						/* NOTE: even though this is now MSG_INT */
						/* it is actually more complicated than this. */
						/* we actually send multiple data types. */
						/* we can do this correctly when Bill changes */
						/* tools.  This isn't a problem except between */
						/* heterogeneous machines. */
						msg = BMcreate_msg(i,-1,MSG_INT,
							clique2inode->proc[cl_ind]); CHKERRN(0);
						BMadd_msg(from_msg,msg,procinfo); CHKERRN(0);
						MY_MALLOCN(setup_data,(int *),sizeof(int)*3,1);
						setup_data[0] = inodes[in_ind].gcol_num;
						setup_data[1] = inodes[in_ind].length;
						setup_data[2] = inodes[in_ind].num_cols;
						BMset_setup_data(msg,setup_data,3*sizeof(int),
							BSfree_comm_data); CHKERRN(0);
						MY_MALLOCN(user_data,(int *),sizeof(int)*2,1);
						user_data[0] = cl_ind;
						user_data[1] = in_ind;
						BMset_user_data(msg,user_data,sizeof(int)*2,
							BSfree_comm_data); CHKERRN(0);
					}
				}
			}
		}

		/* now, let's work out what I need to send */
		phase_ptr = BMget_phase(from_msg,i); CHKERRN(0);
		/* NOTE: even though this is now MSG_INT */
		/* it is actually more complicated than this. */
		/* we actually send multiple data types. */
		/* we can do this correctly when Bill changes */
		/* tools.  This isn't a problem except between */
		/* heterogeneous machines. */
		count = BMfix_send(SETUP_FACTOR_MSG,COMP_MSG_BASE,MSG_INT,to_msg,
			phase_ptr,BSfree_comm_data,procinfo); CHKERRN(0);
		
		/* now free up the setup data */
		msg = NULL;
		while ((msg = BMnext_msg(phase_ptr,msg)) != NULL) {
			CHKERRN(0);
			BMfree_setup_data(msg);
			CHKERRN(0);
		}
		CHKERRN(0);
	}

	MY_MALLOCN(comm_ptr,(BScomm *),sizeof(BScomm),1);
	comm_ptr->to_msg = to_msg;
	comm_ptr->from_msg = from_msg;
	return(comm_ptr);
}
