#include "BSprivate.h"

/*@ BSsetup_block - Change the setup for triangular matrix multiplication
                    to allow for multiple vectors

    Input Parameters:
.   A - a sparse matrix
.   comm - the communication structure
.   block_size - the number of vectors
.   procinfo - the usual processor stuff

    Output Parameters:
.   comm - the communication structure modified for a block of vectors

    Returns:
    void

 @*/
void BSsetup_block(A,comm,block_size,procinfo)
BSpar_mat *A;
BScomm *comm;
int	block_size;
BSprocinfo *procinfo;
{
	BMphase *to_phase, *from_phase;
	BMmsg *msg;
	int	i;
	BSnumbering *color2clique;
	int	msg_len;
	FLOAT *msg_buf;

	color2clique = A->color2clique;

	/* now do this phase by phase */
	for (i=0;i<color2clique->length-1;i++) {
		/* first send my messages */
		to_phase = BMget_phase(comm->to_msg,i); CHKERR(0);
		msg = NULL;
		while ((msg = BMnext_msg(to_phase,msg)) != NULL) {
			CHKERR(0);
			msg_buf = (FLOAT *) BMget_msg_ptr(msg); CHKERR(0);
			msg_len = BMget_msg_size(msg); CHKERR(0);
			if (msg_buf != NULL) {
				MY_FREE(msg_buf);
			}
			BMset_msg_ptr(msg,NULL); CHKERR(0);
			BMset_msg_size(msg,msg_len*block_size); CHKERR(0);
		}
		CHKERR(0);

		/* receive my messages and do non-local work */
		from_phase = BMget_phase(comm->from_msg,i); CHKERR(0);
		msg = NULL;
		while ((msg = BMnext_msg(from_phase,msg)) != NULL) {
			CHKERR(0);
			msg_buf = (FLOAT *) BMget_msg_ptr(msg); CHKERR(0);
			msg_len = BMget_msg_size(msg); CHKERR(0);
			if (msg_buf != NULL) {
				MY_FREE(msg_buf);
			}
			BMset_msg_ptr(msg,NULL); CHKERR(0);
			BMset_msg_size(msg,msg_len*block_size); CHKERR(0);
		}
		CHKERR(0);
	}

	BMalloc_msg(comm->to_msg); CHKERR(0);
	BMalloc_msg(comm->from_msg); CHKERR(0);
}
