#include "BSprivate.h"

/*@ BSset_diagv - Set the diagonal equal to a vector

    Input Parameters:
.   A - a sparse matrix
.   diag - the vector
.   procinfo - the usual processor stuff

    Output Parameters:
.   A - a sparse matrix with the diagonal set to diag

    Returns:
    void

 @*/
void BSset_diagv(A,diag,procinfo)
BSpar_mat *A;
FLOAT 	*diag;
BSprocinfo *procinfo;
{
	int	i;
	FLOAT	*matrix;
	int	cl_ind, size;
	BScl_2_inode *cliques;
	int	count;

	cliques = A->clique2inode;
	count = 0;
	for (cl_ind=0;cl_ind<cliques->num_cols;cl_ind++) {
		if (cliques->proc[cl_ind] == procinfo->my_id) {
			matrix = cliques->d_mats[cl_ind].matrix;
			size = cliques->d_mats[cl_ind].size;
			for (i=0;i<size;i++) {
				matrix[(i*size)+i] = diag[count];
				count++;
			}
		}
	}
}
