#include "BSprivate.h"

/*@ BSset_diag - Set the diagonal of A to a constant

    Input Parameters:
.   A - a sparse matrix
.   alpha - the constant
.   procinfo - the usual processor stuff

    Output Parameters:
.   A - a sparse matrix with the diagonal set to alpha

    Returns:
    void

 @*/
/* Set the diagonal of the matrix to alpha */
void BSset_diag(A,alpha,procinfo)
BSpar_mat *A;
FLOAT 	alpha;
BSprocinfo *procinfo;
{
	int	i;
	FLOAT	*matrix;
	int	cl_ind, size;
	BScl_2_inode *cliques;

	cliques = A->clique2inode;
	for (cl_ind=0;cl_ind<cliques->num_cols;cl_ind++) {
		if (cliques->proc[cl_ind] == procinfo->my_id) {
			matrix = cliques->d_mats[cl_ind].matrix;
			size = cliques->d_mats[cl_ind].size;
			for (i=0;i<size;i++) {
				matrix[(i*size)+i] = alpha;
			}
		}
	}
}
