#include "BSprivate.h"

/*+ BSrow_perm - Build a list that can access the rows of A in a permuted order

    Input Parameters:
.   A - a sparse matrix
.   iperm - the permutation

    Returns:
    a structure that can access the rows of A in permuted order

 +*/
BSsprow **BSrow_perm(A,iperm)
BSspmat *A;
BSpermutation *iperm;
{
	int	i;
	BSsprow **t_rows;

	/* build a temporary row list that is permuted by gnum */
	MY_MALLOCN(t_rows,(BSsprow **),sizeof(BSsprow *)*A->num_rows,1);
	for (i=0;i<A->num_rows;i++) {
		t_rows[i] = A->rows[iperm->perm[i]];
	}

	return(t_rows);
}
