#include	"BSprivate.h"

/*+ BSrem_diag - Remove the diagonal entries from the sparse matrix

    Input Parameters:
.   A - the sparse matrix

    Output Parameters:
.   A - the sparse matrix with diagonals hidden

    Returns:
    void

    Notes:
    The entries are actually hidden at the end.  This routine is
    necessary to interface to an older coloring algorithm.  The
    entries are reinserted (moved back) by another BSins_diag.
 +*/
void	BSrem_diag(A)
BSspmat *A;
{
	int	i, j;
	int	ival;
	BSsprow *row;

	for (i=0;i<A->num_rows;i++) {
		row = A->rows[i];
		row->length--;
		ival = row->col[row->diag_ind];
		for (j=row->diag_ind;j<row->length;j++) {
			row->col[j] = row->col[j+1];
		}
		row->diag_ind = -row->diag_ind;
		row->col[row->length] = ival;
	}
}
