#include "BSprivate.h"

/*+ BSpar_ip - Compute an inner product across processors

    Input Parameters:
.   num_cols - the length of the vectors
.   vec1 - the first vector
.   vec2 - the second vector
.   procinfo - the usual processor stuff

    Returns:
    the result

 +*/
FLOAT BSpar_ip(num_cols,vec1,vec2,procinfo)
int	num_cols;
FLOAT	*vec1;
FLOAT	*vec2;
BSprocinfo *procinfo;
{
	int	i;
	FLOAT result, work;

	/* compute my contribution to the IP */
	result = 0.0;
	for (i=0;i<num_cols;i++) {
		result += vec1[i]*vec2[i];
	}
	GFLSUM((&result),1,(&work),procinfo->procset);
	return(result);
}
