#include "BSprivate.h"

/*+ BSpar_bip - Inner products on several vectors at once

    Input Parameters:
.   num_cols - the length of the vectors
.   vec1 - the first block of contiguous vectors
.   vec2 - the second block of contiguous vectors
.   nBS - the number of vectors
.   procinfo - the usual processor stuff

    Output Parameters:
.   result - the result of each inner product (length nBS)

    Returns:
    void

 +*/
void BSpar_bip(num_cols,vec1,vec2,nBS,result,procinfo)
int	num_cols;
FLOAT	*vec1;
FLOAT	*vec2;
int	nBS;
FLOAT *result;
BSprocinfo *procinfo;
{
	int	i, j;
	FLOAT	t;
	FLOAT	*t_vec1, *t_vec2;
	FLOAT	*work;

	/* compute my contribution to the IP */
	t_vec1 = vec1;
	t_vec2 = vec2;
	for (j=0;j<nBS;j++) {
		t = 0.0;
		for (i=0;i<num_cols;i++) {
			t += t_vec1[i]*t_vec2[i];
		}
		result[j] = t;
		t_vec1 += num_cols;
		t_vec2 += num_cols;
	}
	MY_MALLOC(work,(FLOAT *),sizeof(FLOAT)*nBS,1);
	GFLSUM(result,nBS,work,procinfo->procset);
	MY_FREE(work);
}
