#include "BSprivate.h"

/*+ BSoff_gnum - Find the global row number of the first row in each clique

    Input Parameters:
.   offset - the global row number of the first row in each color
.   numbering - the coloring of the cliques
.   distr - the number of rows in each clique

    Returns:
    the global row number of the first row in each clique

 +*/
BSnumbering	*BSoff_gnum(offset,numbering,distr)
BSnumbering *offset;
BSnumbering *numbering;
BSdistribution *distr;
{
	BSnumbering	*gnum;
	int	*count;
	int	 i;
	int	ind;

	gnum = BSalloc_numbering(numbering->length); CHKERRN(0);
	MY_MALLOCN(count,(int *),sizeof(int)*offset->length,1);
	for (i=0;i<offset->length;i++) count[i] = 0;
	if (distr != NULL) {
		for (i=0;i<numbering->length;i++) {
			ind = numbering->numbers[i];
			gnum->numbers[i] = offset->numbers[ind] + count[ind];
			count[ind] += distr->distribution[i];
		}
	} else {
		for (i=0;i<numbering->length;i++) {
			ind = numbering->numbers[i];
			gnum->numbers[i] = offset->numbers[ind] + count[ind];
			count[ind]++;
		}
	}
	MY_FREEN(count);
	return(gnum);
}
