#include "BSprivate.h"

/*+ BSnz_2_inode - Copy the nonzeros of A into the inode structure

    Input Parameters:
.   A - the original sparse matrix
.   perm_rows - indices into the rows of A in permuted order
.   col_iA - the inode data structure
.   col_cA - the clique data structure
.   procinfo - the usual processor stuff

    Output Parameters:
.   col_iA - now contains the nonzeros of A

    Returns:
    void

 +*/
void BSnz_2_inode(A,perm_rows,col_iA,col_cA,procinfo)
BSspmat *A;
BSsprow **perm_rows;
BSinode_list *col_iA;
BScl_2_inode *col_cA;
BSprocinfo *procinfo;
{
	int	i, j;
	int	cl_ind, in_ind;
	BSinode *inode;
	FLOAT	**nz_ptr;
	int	size, ind;
	FLOAT	*cl_mat;
	int	r_offset, c_offset;

	MY_MALLOC(nz_ptr,(FLOAT **),sizeof(FLOAT *)*A->num_rows,1);
	for (i=0;i<A->num_rows;i++) {
		nz_ptr[i] = perm_rows[i]->nz;
	}
	for (cl_ind=0;cl_ind<col_cA->num_cols;cl_ind++) {
		/* local or global? */
		if (col_cA->proc[cl_ind] == procinfo->my_id) {
			size = col_cA->d_mats[cl_ind].size;
			ind = col_cA->d_mats[cl_ind].local_ind;
			cl_mat = col_cA->d_mats[cl_ind].matrix;
			for (r_offset=0;r_offset<size;r_offset++) {
				for (c_offset=0;c_offset<=r_offset;c_offset++) {
					cl_mat[(c_offset*size)+r_offset] = *(nz_ptr[ind+r_offset]);
					(nz_ptr[ind+r_offset])++;
				}
			}
			for (in_ind=col_cA->inode_index[cl_ind];
				in_ind<col_cA->inode_index[cl_ind+1];in_ind++) {
				inode = &(col_iA->list[in_ind]);
				for (i=0;i<inode->length;i++) {
					for (j=0;j<inode->num_cols;j++) {
						inode->nz[(j*inode->length)+i] = 
							*(nz_ptr[inode->row_num[i]]);
						(nz_ptr[inode->row_num[i]])++;
					}
				}
			}
		} else {
			for (in_ind=col_cA->inode_index[cl_ind];
				in_ind<col_cA->inode_index[cl_ind+1];in_ind++) {
				inode = &(col_iA->list[in_ind]);
				for (i=0;i<inode->length;i++) {
					for (j=0;j<inode->num_cols;j++) {
						inode->nz[(j*inode->length)+i] = 
							*(nz_ptr[inode->row_num[i]]);
						(nz_ptr[inode->row_num[i]])++;
					}
				}
			}
		}
	}
	MY_FREE(nz_ptr);
}
