#include	"BSprivate.h"

/*+ BSnum2perm - Find a permutation that will put numbered nodes 
                 in sorted order

    Input Parameters:
.   numbering - the numbering
.   distr - the distribution of the numbering

    Returns:
    the permutation

 +*/
BSpermutation	*BSnum2perm(numbering,distr)
BSnumbering	*numbering;
BSdistribution	*distr;
{
	BSpermutation	*perm;
	int	i;
	int	*offset, count;

	/* allocate permutation */
	perm = BSalloc_permutation(numbering->length); CHKERRN(0);

	/* find local permutation */
	MY_MALLOCN(offset,(int *),sizeof(int)*(distr->max+1),1);
	count = 0;
	for (i=0;i<=distr->max;i++) {
		offset[i] = count;
		count += distr->distribution[i];
	}
	for (i=0;i<numbering->length;i++) {
		perm->perm[i] = offset[numbering->numbers[i]];
		offset[numbering->numbers[i]]++;
	}
	MY_FREEN(offset);

	return(perm);
}

