#include	"BSprivate.h"

/*+ BSnum2distr - Compute the distribution of a numbering

    Input Parameters:
.   numbering - the numbering

    Returns:
    the distribution of the numbering

    Notes: The assumption is that the numbering runs from 0 to n
    and that the distribution will tell how many 0's, how many 1's, etc.

 +*/
BSdistribution *BSnum2distr(numbering)
BSnumbering	*numbering;
{
	BSdistribution	*distr;
	int	max;
	int	i;

	max = 0;
	for (i=0;i<numbering->length;i++) {
		if (numbering->numbers[i] > max) max = numbering->numbers[i];
	}
	distr = BSalloc_distribution(max); CHKERRN(0);
	for (i=0;i<=max;i++) {
		distr->distribution[i] = 0;
	}
	for (i=0;i<numbering->length;i++) {
		distr->distribution[numbering->numbers[i]]++;
	}
	return(distr);
}

