#include	"BSprivate.h"

/*+ BSperm_ivec - Permute an integer vector according to a permutation

    Input Parameters:
.   in_vec - the vector to permute
.   permutation - the permutation

    Output Parameters:
.   out_vec - the permuted vector

    Returns:
    void

 +*/
void	BSperm_ivec(in_vec,out_vec,permutation)
int	*in_vec;
int	*out_vec;
BSpermutation	*permutation;
{
	int	i;
	
	for (i=0;i<permutation->length;i++) {
		out_vec[permutation->perm[i]] = in_vec[i];
	}
}

/*+ BSiperm_ivec - Permute an integer vector according to an inverse permutation

    Input Parameters:
.   in_vec - the vector to permute
.   permutation - the permutation

    Output Parameters:
.   out_vec - the permuted vector

    Returns:
    void

 +*/
void	BSiperm_ivec(in_vec,out_vec,permutation)
int	*in_vec;
int	*out_vec;
BSpermutation	*permutation;
{
	int	i;
	
	for (i=0;i<permutation->length;i++) {
		out_vec[i] = in_vec[permutation->perm[i]];
	}
}

/*+ BSperm_dvec - Permute a DP vector according to a permutation

    Input Parameters:
.   in_vec - the vector to permute
.   permutation - the permutation

    Output Parameters:
.   out_vec - the permuted vector

    Returns:
    void

 +*/
void	BSperm_dvec(in_vec,out_vec,permutation)
FLOAT	*in_vec;
FLOAT	*out_vec;
BSpermutation	*permutation;
{
	int	i;
	
	for (i=0;i<permutation->length;i++) {
		out_vec[permutation->perm[i]] = in_vec[i];
	}
}

/*+ BSiperm_dvec - Permute a DP vector according to an inverse permutation

    Input Parameters:
.   in_vec - the vector to permute
.   permutation - the permutation

    Output Parameters:
.   out_vec - the permuted vector

    Returns:
    void

 +*/
void	BSiperm_dvec(in_vec,out_vec,permutation)
FLOAT	*in_vec;
FLOAT	*out_vec;
BSpermutation	*permutation;
{
	int	i;
	
	for (i=0;i<permutation->length;i++) {
		out_vec[i] = in_vec[permutation->perm[i]];
	}
}

/*+ BSperm2iperm - Compute an inverse permutation from a permutation

    Input Parameters:
.   permutation - the permutation

    Output Parameters:
.   permutation - the inverse permutation

    Returns:
    void

 +*/
void	BSperm2iperm(permutation,inv_permutation)
BSpermutation	*permutation;
BSpermutation	*inv_permutation;
{
	int	i;
	
	for (i=0;i<permutation->length;i++) {
		inv_permutation->perm[permutation->perm[i]] = i;
	}
}
