#include "BSprivate.h"

/*@ BSmat_subtract - Subtract shift*B from A

    Input Parameters:
.   A - a sparse matrix
.   B - a sparse matrix
.   shift - the multiple of B to subtract from A

    Returns:
    void

 @*/
void	BSmat_subtract(A,B,shift)
BSspmat	*A;
BSspmat	*B;
FLOAT	shift;
{
	int	i;
	BSsprow **Arows = A->rows;
	BSsprow **Brows = B->rows;
	int	*colA, *colB;
	int	lenA, lenB;
	FLOAT	*nzA, *nzB;
	int	indA, indB;

	if (shift == 0.0) return;

	for (i=0;i<A->num_rows;i++) {
		indA = 0;
		indB = 0;
		lenA = Arows[i]->length;
		lenB = Brows[i]->length;
		colA = Arows[i]->col;
		colB = Brows[i]->col;
		nzA = Arows[i]->nz;
		nzB = Brows[i]->nz;
		while ((indA < lenA) && (indB < lenB)) {
			if (colA[indA] == colB[indB]) {
				nzA[indA] -= (nzB[indB]*shift);
				indA++;
				indB++;
			} else if (colA[indA] > colB[indB]) {
				indB++;
			} else {
				indA++;
			}
		}
	}
}
